/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class FrontCheckLock
extends ReentrantLock {
    private static final long serialVersionUID = 1L;
    private static FrontCheckLock context = new FrontCheckLock();
    private Map<String, FrontCheckLock> localLocks = new ConcurrentHashMap<String, FrontCheckLock>();
    private String name;
    private AtomicInteger count = new AtomicInteger(0);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AtomicInteger getCount() {
        return this.count;
    }

    public int updateCount(int delta) {
        return this.count.addAndGet(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lock(String lockName, long timeout, TimeUnit unit) {
        FrontCheckLock lc = FrontCheckLock.context.localLocks.get(lockName);
        if (lc == null) {
            Map<String, FrontCheckLock> map = FrontCheckLock.context.localLocks;
            synchronized (map) {
                lc = FrontCheckLock.context.localLocks.get(lockName);
                if (lc == null) {
                    lc = new FrontCheckLock();
                    FrontCheckLock.context.localLocks.put(lockName, lc);
                }
            }
        }
        lc.updateCount(1);
        try {
            return lc.tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void unlock(String lockName) {
        FrontCheckLock lc = FrontCheckLock.context.localLocks.get(lockName);
        if (lc != null) {
            lc.unlock();
            if (lc.updateCount(-1) == 0) {
                FrontCheckLock.context.localLocks.remove(lockName);
                lc = null;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrontCheckLock other = (FrontCheckLock)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

