/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.lock.redis;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.async.RetryAsyncTaskExecutor;
import org.dromara.mendmix.common.async.RetryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;

public class RedisDistributeLock {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.common");
    private static final String KEY_PREFIX = "_dlock:";
    private static StringRedisTemplate redisTemplate;
    private static String getLockLua;
    DefaultRedisScript<Long> lockScript = new DefaultRedisScript(getLockLua, Long.class);
    private static final long _DEFAULT_MAX_WAIT = 60000L;
    private String lockName;
    private long maxLiveMillis;

    public static StringRedisTemplate getRedisTemplate() {
        return redisTemplate;
    }

    public static void setRedisTemplate(StringRedisTemplate redisTemplate) {
        RedisDistributeLock.redisTemplate = redisTemplate;
    }

    public RedisDistributeLock(String resKey) {
        this(resKey, 60000L);
    }

    public RedisDistributeLock(String resKey, long maxLiveMillis) {
        this.lockName = KEY_PREFIX.concat(resKey);
        this.maxLiveMillis = maxLiveMillis;
    }

    public void lock() {
        boolean locked = this.tryLock(this.maxLiveMillis, TimeUnit.MILLISECONDS);
        if (!locked) {
            this.unlock();
            throw new MendmixBaseException("Lock[" + this.lockName + "] timeout");
        }
    }

    public boolean tryLock() {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return true;
        }
        String threadKey = this.buildThreadKey();
        Long result = (Long)redisTemplate.execute(this.lockScript, Arrays.asList(this.lockName), new Object[]{threadKey, String.valueOf(this.maxLiveMillis)});
        return result != null && result == 1L;
    }

    public boolean tryLock(long time, TimeUnit unit) {
        long start = System.currentTimeMillis();
        boolean res = this.tryLock();
        if (res) {
            return res;
        }
        long sleep = 100L;
        while (!res) {
            try {
                TimeUnit.MILLISECONDS.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = this.tryLock();
            if (res) {
                return res;
            }
            if (sleep > 20L) {
                sleep -= 10L;
            }
            if (System.currentTimeMillis() - start <= unit.toMillis(time)) continue;
            return false;
        }
        return false;
    }

    public boolean isIdle() {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return true;
        }
        return redisTemplate.hasKey((Object)this.lockName) == false;
    }

    public long blockUtilIdle(long time, TimeUnit unit) {
        if (this.isIdle()) {
            return 0L;
        }
        long start = System.currentTimeMillis();
        boolean idle = false;
        long sleep = 100L;
        while (!idle) {
            try {
                TimeUnit.MILLISECONDS.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            idle = this.isIdle();
            if (idle) {
                return System.currentTimeMillis() - start;
            }
            if (sleep > 20L) {
                sleep -= 10L;
            }
            if (System.currentTimeMillis() - start <= unit.toMillis(time)) continue;
            return System.currentTimeMillis() - start;
        }
        return 0L;
    }

    public void unlock() {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return;
        }
        String val = (String)redisTemplate.opsForValue().get((Object)this.lockName);
        String threadKey = this.buildThreadKey();
        if (threadKey.equals(val)) {
            redisTemplate.delete((Object)this.lockName);
        } else if (val != null) {
            logger.info(">>\u7ebf\u7a0b[{}] \u89e3\u9501\u4e0d\u5339\u914d!! -> lockName:{},\u671f\u671b\u7ebf\u7a0b:{}", new Object[]{threadKey, this.lockName, val});
        }
    }

    public void unlock(final int delayMills) {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return;
        }
        if (delayMills <= 0) {
            this.unlock();
            return;
        }
        final String val = (String)redisTemplate.opsForValue().get((Object)this.lockName);
        final String threadKey = this.buildThreadKey();
        RetryAsyncTaskExecutor.execute(new RetryTask(){

            @Override
            public String traceId() {
                return RedisDistributeLock.this.lockName;
            }

            @Override
            public boolean process() throws Exception {
                Thread.sleep(delayMills);
                if (threadKey.equals(val)) {
                    redisTemplate.delete((Object)RedisDistributeLock.this.lockName);
                } else if (val != null) {
                    logger.info(">>\u7ebf\u7a0b[{}] \u89e3\u9501\u4e0d\u5339\u914d!! -> lockName:{},\u671f\u671b\u7ebf\u7a0b:{}", new Object[]{threadKey, RedisDistributeLock.this.lockName, val});
                }
                return true;
            }
        });
    }

    private String buildThreadKey() {
        return new StringBuilder(GlobalContext.getWorkerId()).append("@").append(Thread.currentThread().getName()).toString();
    }

    static {
        getLockLua = "local res = redis.call('setnx', KEYS[1],ARGV[1])\nif tonumber(res) > 0 then\n\tredis.call('PEXPIRE', KEYS[1], ARGV[2])\n\treturn 1\nelse \n\treturn 0\nend";
    }
}

