/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.util.SimpleCryptUtils;

public class AuthUser {
    private static final long EXP = 3600000L;
    private static final String CONTACT_CHAR = "#";
    private static final String PLACEHOLDER_CHAR = "{-}";
    private String id;
    private String name;
    private String type;
    private String bunitId;
    private String deptId;
    private String postId;
    private String principalType;
    private String principalId;
    private boolean admin;

    public AuthUser() {
    }

    public AuthUser(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBunitId() {
        return this.bunitId;
    }

    public void setBunitId(String bunitId) {
        this.bunitId = bunitId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getPostId() {
        return this.postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(String principalType) {
        this.principalType = principalType;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public String toEncodeString() {
        StringBuilder builder = new StringBuilder();
        builder.append(AuthUser.trimToPlaceHolder(this.id)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.name)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.type)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.bunitId)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.deptId)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.postId)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.principalType)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.principalId)).append(CONTACT_CHAR);
        builder.append(this.admin).append(CONTACT_CHAR);
        builder.append(System.currentTimeMillis()).append(CONTACT_CHAR);
        return SimpleCryptUtils.encrypt(builder.toString());
    }

    public static AuthUser decode(String encodeString) {
        if (StringUtils.isBlank((CharSequence)encodeString)) {
            return null;
        }
        encodeString = SimpleCryptUtils.decrypt(encodeString);
        String[] splits = encodeString.split(CONTACT_CHAR);
        if (System.currentTimeMillis() - Long.parseLong(splits[splits.length - 1]) > 3600000L) {
            throw new MendmixBaseException("\u7528\u6237\u4fe1\u606f\u5931\u6548");
        }
        AuthUser user = new AuthUser();
        user.setId(AuthUser.placeHolderToNull(splits[0]));
        user.setName(AuthUser.placeHolderToNull(splits[1]));
        user.setType(AuthUser.placeHolderToNull(splits[2]));
        user.setBunitId(AuthUser.placeHolderToNull(splits[3]));
        user.setDeptId(AuthUser.placeHolderToNull(splits[4]));
        user.setPostId(AuthUser.placeHolderToNull(splits[5]));
        user.setPrincipalType(AuthUser.placeHolderToNull(splits[6]));
        user.setPrincipalId(AuthUser.placeHolderToNull(splits[7]));
        user.setAdmin(Boolean.parseBoolean(splits[8]));
        return user;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    private static String trimToPlaceHolder(String value) {
        return (value = StringUtils.trimToNull((String)value)) == null ? PLACEHOLDER_CHAR : value;
    }

    private static String placeHolderToNull(String value) {
        return PLACEHOLDER_CHAR.equals(value) ? null : value;
    }
}

