/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.model;

import java.util.ArrayList;
import java.util.List;
import org.dromara.mendmix.common.model.PageParams;

public class Page<T>
extends PageParams {
    private long total;
    private int pages;
    private List<T> data;

    public Page() {
    }

    public Page(int pageNo, int pageSize, long total, List<T> data) {
        this.setPageNo(pageNo);
        this.setPageSize(pageSize);
        this.total = total;
        this.data = data;
        this.pages = (int)(this.total / (long)this.getPageSize() + (long)(this.total % (long)this.getPageSize() == 0L ? 0 : 1));
    }

    public Page(PageParams pageParams, long total, List<T> data) {
        this.setPageNo(pageParams.getPageNo());
        this.setPageSize(pageParams.getPageSize());
        this.total = total;
        this.data = data;
        this.pages = (int)(this.total / (long)this.getPageSize() + (long)(this.total % (long)this.getPageSize() == 0L ? 0 : 1));
    }

    public static <T> Page<T> blankPage(int pageNo, int pageSize) {
        Page<T> page = new Page<T>();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.total = 0L;
        page.data = new ArrayList<T>(0);
        page.setPages(0);
        return page;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public List<T> getData() {
        return this.data == null ? (this.data = new ArrayList<T>()) : this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }
}

