/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.model;

import java.util.ArrayList;
import java.util.List;
import org.dromara.mendmix.common.model.OrderBy;

public class PageParams {
    private int pageNo = 1;
    private int pageSize = 10;
    private List<OrderBy> orderBys;
    private boolean concurrency;

    public PageParams() {
    }

    public PageParams(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public PageParams(int pageNo, int pageSize, OrderBy orderBy) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderBy(orderBy);
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<OrderBy> getOrderBys() {
        return this.orderBys;
    }

    public void setOrderBys(List<OrderBy> orderBys) {
        this.orderBys = orderBys;
    }

    public boolean isConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(boolean concurrency) {
        this.concurrency = concurrency;
    }

    public PageParams orderBy(OrderBy orderBy) {
        if (orderBy == null) {
            return this;
        }
        if (this.orderBys == null) {
            this.orderBys = new ArrayList<OrderBy>(2);
        }
        this.orderBys.add(orderBy);
        return this;
    }

    public PageParams orderBys(OrderBy ... orderBys) {
        if (this.orderBys == null) {
            this.orderBys = new ArrayList<OrderBy>(orderBys.length);
        }
        for (OrderBy order : orderBys) {
            if (order == null) continue;
            this.orderBys.add(order);
        }
        return this;
    }

    public int offset() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public String toString() {
        return "PageParams [pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + "]";
    }
}

