/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.model;

import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinSelecter {
    private int maxIndex;
    private AtomicInteger counter;

    public void incrNode() {
        ++this.maxIndex;
    }

    public void decrNode() {
        --this.maxIndex;
    }

    public RoundRobinSelecter(int total) {
        this.maxIndex = total - 1;
        this.counter = new AtomicInteger(-1);
    }

    public int select() {
        if (this.maxIndex == 0) {
            return 0;
        }
        int next = this.counter.updateAndGet(x -> x >= this.maxIndex ? 0 : x + 1);
        return next;
    }

    public static void main(String[] args) {
        RoundRobinSelecter selecter = new RoundRobinSelecter(5);
        for (int i = 0; i < 100; ++i) {
            System.out.println(selecter.select());
        }
    }
}

