/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TreeModel {
    private String id;
    private String name;
    private String value;
    private String parentId;
    private boolean checked = false;
    private boolean disabled = false;
    private int sort;
    private List<TreeModel> children;

    public TreeModel() {
    }

    public TreeModel(String id, String name, String value, String pid) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.parentId = pid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public void addChild(TreeModel child) {
        this.children = this.children == null ? (this.children = new ArrayList<TreeModel>()) : this.children;
        this.children.add(child);
    }

    public List<TreeModel> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeModel> children) {
        this.children = children;
    }

    public boolean isLeaf() {
        return this.children != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.parentId == null ? 0 : this.parentId.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeModel other = (TreeModel)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.parentId == null ? other.parentId != null : !this.parentId.equals(other.parentId)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static <T extends TreeModel> TreeModel build(List<T> models) {
        TreeModel root = new TreeModel();
        if (models.isEmpty()) {
            root.children = new ArrayList<TreeModel>(0);
            return root;
        }
        HashMap<String, TreeModel> modelMap = new HashMap<String, TreeModel>();
        for (TreeModel model : models) {
            if (model.isLeaf()) continue;
            modelMap.put(model.getId(), model);
        }
        for (TreeModel model : models) {
            if (StringUtils.isBlank((CharSequence)model.getParentId()) && !model.isLeaf() || !modelMap.containsKey(model.getParentId())) {
                root.addChild(model);
                continue;
            }
            ((TreeModel)modelMap.get(model.getParentId())).addChild(model);
        }
        TreeModel.sortedChildren(root);
        return root;
    }

    private static void sortedChildren(TreeModel model) {
        List<TreeModel> children = model.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        children.sort(Comparator.comparingInt(TreeModel::getSort));
        for (TreeModel child : children) {
            TreeModel.sortedChildren(child);
        }
    }
}

