/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.exception.DefaultExceptions;
import org.dromara.mendmix.common.util.JsonUtils;

public class WrapperResponse<T> {
    private int code = 200;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String bizCode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String msg;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T data;
    private Map<String, String> contextParams;

    public WrapperResponse() {
    }

    public WrapperResponse(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public WrapperResponse(int code, String bizCode, String msg) {
        this.code = code;
        this.bizCode = bizCode;
        this.msg = msg;
    }

    public WrapperResponse(T data) {
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean successed() {
        return this.code == 200;
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public void setContextParams(Map<String, String> contextParams) {
        this.contextParams = contextParams;
    }

    public String toString() {
        return JsonUtils.toJson(this);
    }

    public static WrapperResponse<Void> success() {
        return new WrapperResponse<Void>();
    }

    public static <T> WrapperResponse<T> success(T data) {
        return new WrapperResponse<T>(data).withContextParam();
    }

    public static <T> WrapperResponse<T> fail(String msg) {
        return WrapperResponse.fail(500, null, msg);
    }

    public static <T> WrapperResponse<T> fail(int code, String bizCode, String message) {
        WrapperResponse<T> response = new WrapperResponse<T>();
        response.code = code;
        response.bizCode = bizCode;
        response.msg = message;
        return response.withContextParam();
    }

    public static <T> WrapperResponse<T> fail(int code, String msg) {
        return WrapperResponse.fail(code, null, msg);
    }

    public static String buildErrorJSON(int code, String msg) {
        return JsonUtils.toJson(WrapperResponse.fail(code, msg));
    }

    public static <T> WrapperResponse<T> fail(Exception e) {
        MendmixBaseException be = e instanceof MendmixBaseException ? (MendmixBaseException)e : DefaultExceptions.SYSTEM_EXCEPTION;
        return WrapperResponse.fail(be.getCode(), be.getBizCode(), be.getMessage());
    }

    public WrapperResponse<T> withContextParam() {
        if (this.contextParams != null) {
            return this;
        }
        this.contextParams = new LinkedHashMap<String, String>(5);
        String val = CurrentRuntimeContext.getContextVal("x-request-id", false);
        this.contextParams.put("x-request-id", val);
        return this;
    }
}

