/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.sequence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.jdbc.DataSourceGroups;
import org.dromara.mendmix.common.jdbc.JdbcExecutor;
import org.dromara.mendmix.common.lock.redis.RedisDistributeLock;
import org.dromara.mendmix.common.sequence.RandomType;
import org.dromara.mendmix.common.sequence.SeqTimeExpr;
import org.dromara.mendmix.common.sequence.SequenceRule;
import org.dromara.mendmix.common.task.SubTimerTask;
import org.dromara.mendmix.common.util.DateUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SequenceGenerateService
implements SubTimerTask,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.common");
    private static long taskInterval = RandomUtils.nextLong((long)5000L, (long)10000L);
    private static Duration queuePopWaiting = Duration.ofMillis(taskInterval + 10000L);
    private static final String NONE_TIME_EXPRE = "none";
    private static final String SEQUENCE_QUEUE_KEY_TPL = "sequence.queue:%s_%s";
    private static final String SEQUENCE_QUEUE_LAST_SEQ_KEY_TPL = "sequence.queue.lastSeq:%s";
    private static String[] paddingzeros = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};
    private static SequenceGenerateService me;
    @Autowired(required=false)
    @Qualifier(value="defaultDataSource")
    private DataSource defaultDataSource;
    @Value(value="${sequence.code.prefix:}")
    private String codePrefix;
    private List<String> matchCodes = ResourceUtils.getList("sequence.code.scopes");
    @Value(value="${sequence.batch.produce.count:200}")
    private int batchSize;
    private int threshold;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private JdbcExecutor jdbcExecutor;
    private boolean noRuleTable = false;
    private AtomicReference<Map<String, SequenceRule>> sequenceRules = new AtomicReference();

    public static String next(String code) {
        if (me == null) {
            throw new MendmixBaseException("SequenceGenerateService not init");
        }
        return me.genSequence(code);
    }

    public String genSequence(String code) {
        SequenceRule rule = this.findRuleByCode(code);
        String timeSequence = NONE_TIME_EXPRE;
        if (StringUtils.isNotBlank((CharSequence)rule.getTimeExpr())) {
            timeSequence = this.buildTimeExprSequence(rule.getTimeExpr());
        }
        String queueName = String.format(SEQUENCE_QUEUE_KEY_TPL, code, timeSequence);
        if (this.redisTemplate.opsForList().size((Object)queueName) < (long)this.threshold) {
            this.generateWithLock(rule, queueName, timeSequence);
        }
        String item = (String)this.redisTemplate.opsForList().rightPop((Object)queueName, queuePopWaiting);
        return item;
    }

    private void procuceSequenceAndAddQueue(SequenceRule rule, String timeSequence, String queueName) {
        int hasCount = this.redisTemplate.opsForList().size((Object)queueName).intValue();
        int produceNums = this.batchSize - hasCount;
        if (produceNums <= this.threshold) {
            return;
        }
        boolean isReset = this.isCrossPeriodReset(rule, queueName);
        RedisDistributeLock resetLck = null;
        String resetMarkKey = null;
        if (isReset) {
            resetMarkKey = "queueName.reset:" + queueName;
            resetLck = new RedisDistributeLock(resetMarkKey);
            resetLck.lock();
            isReset = this.redisTemplate.hasKey((Object)resetMarkKey) == false;
        }
        logger.info(">>>procuceSequence begin -> code:{},queueName:{},isReset:{},produceNums:{}", new Object[]{rule.getCode(), queueName, isReset, produceNums});
        ArrayList<String> sequeueList = new ArrayList<String>(produceNums);
        int[] incrSeqRange = this.updateLastSequenceValue(rule, produceNums, isReset);
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)rule.getPrefix())) {
            builder.append(rule.getPrefix());
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getTimeExpr())) {
            builder.append(timeSequence);
        }
        int prefixLength = builder.length();
        for (int i = incrSeqRange[0]; i < incrSeqRange[1]; ++i) {
            builder.setLength(prefixLength);
            String seq = String.valueOf(i);
            int len = rule.getSeqLength() - seq.length();
            if (len > 0) {
                seq = paddingzeros[len] + seq;
            }
            builder.append(seq);
            if (rule.getRandomLength() > 0) {
                builder.append(RandomStringUtils.random((int)rule.getRandomLength(), (boolean)RandomType.chars(rule.getRandomType()), (boolean)RandomType.numbers(rule.getRandomType())));
            }
            sequeueList.add(builder.toString());
        }
        this.redisTemplate.opsForList().leftPushAll((Object)queueName, sequeueList);
        Date curTime = new Date();
        long expireIn = DateUtils.getDiffSeconds(DateUtils.getDayEnd(curTime), curTime) + 5L;
        this.redisTemplate.expire((Object)queueName, Duration.ofSeconds(expireIn));
        if (isReset) {
            this.redisTemplate.opsForValue().set((Object)resetMarkKey, (Object)queueName);
            this.redisTemplate.expire((Object)resetMarkKey, Duration.ofSeconds(30L));
        }
        logger.info(">>>procuceSequence end -> code:{},queueName:{},isReset:{},incrRange:{}~{}", new Object[]{rule.getCode(), queueName, isReset, incrSeqRange[0], incrSeqRange[1]});
    }

    private SequenceRule findRuleByCode(String code) {
        SequenceRule sequenceRule;
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new MendmixBaseException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SequenceRule sequenceRule2 = code == null ? null : (sequenceRule = this.sequenceRules.get() == null ? null : this.sequenceRules.get().get(code));
        if (sequenceRule == null) {
            sequenceRule = this.jdbcExecutor.queryForObject("SELECT * FROM sequence_rules WHERE code=?", new Object[]{code}, SequenceRule.class);
        }
        return sequenceRule;
    }

    private String buildTimeExprSequence(String timeExpr) {
        String seq = timeExpr;
        Calendar calendar = Calendar.getInstance();
        if (timeExpr.contains(SeqTimeExpr.YEAR.getExpr())) {
            seq = seq.replace(SeqTimeExpr.YEAR.getExpr(), String.valueOf(calendar.get(1)));
        } else if (timeExpr.contains(SeqTimeExpr.SHORT_YEAR.getExpr())) {
            String value = String.valueOf(calendar.get(1)).substring(2);
            seq = seq.replace(SeqTimeExpr.SHORT_YEAR.getExpr(), value);
        }
        if (timeExpr.contains(SeqTimeExpr.MONTH.getExpr())) {
            int month = calendar.get(2) + 1;
            seq = seq.replace(SeqTimeExpr.MONTH.getExpr(), month > 9 ? String.valueOf(month) : "0" + month);
        }
        if (timeExpr.contains(SeqTimeExpr.DAY.getExpr())) {
            int date = calendar.get(5);
            seq = seq.replace(SeqTimeExpr.DAY.getExpr(), date > 9 ? String.valueOf(date) : "0" + date);
        }
        if (timeExpr.length() > 14) {
            if (timeExpr.contains(SeqTimeExpr.HOUR.getExpr())) {
                seq = seq.replace(SeqTimeExpr.HOUR.getExpr(), "");
            }
            if (timeExpr.contains(SeqTimeExpr.MINUTE.getExpr())) {
                seq = seq.replace(SeqTimeExpr.MINUTE.getExpr(), "");
            }
            if (timeExpr.contains(SeqTimeExpr.SECOND.getExpr())) {
                seq = seq.replace(SeqTimeExpr.SECOND.getExpr(), "");
            }
        }
        return seq;
    }

    private int[] updateLastSequenceValue(SequenceRule rule, int produceNums, boolean reset) {
        int endSeq;
        int startSeq;
        String cacheKey = String.format(SEQUENCE_QUEUE_LAST_SEQ_KEY_TPL, rule.getCode());
        if (reset) {
            startSeq = rule.getFirstSequence();
            endSeq = rule.getFirstSequence() + produceNums;
            this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)String.valueOf(endSeq));
        } else {
            endSeq = this.redisTemplate.opsForValue().increment((Object)cacheKey, (long)produceNums).intValue();
            startSeq = endSeq - produceNums;
            if (startSeq == 0) {
                startSeq = 1;
            }
        }
        logger.info(">> updateLastSequenceValue ->code:{},reset:{},startSeq:{},endSeq:{}", new Object[]{rule.getCode(), reset, startSeq, endSeq});
        this.updateDbLastSequenceValue(rule, endSeq);
        return new int[]{startSeq, endSeq};
    }

    private boolean updateDbLastSequenceValue(SequenceRule rule, int updateLastSeq) {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.jdbcExecutor.getconnnection();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement("UPDATE sequence_rules SET last_sequence=?,updated_at=? WHERE id=?");
            statement.setInt(1, updateLastSeq);
            statement.setTimestamp(2, new Timestamp(Calendar.getInstance().getTimeInMillis()));
            statement.setString(3, rule.getId());
            int res = statement.executeUpdate();
            boolean bl = res > 0;
            this.jdbcExecutor.close(null, statement, connection);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.jdbcExecutor.close(null, statement, connection);
                throw throwable;
            }
        }
    }

    @Override
    public void doSchedule() {
        if (this.noRuleTable) {
            return;
        }
        String sql = "SELECT * FROM sequence_rules WHERE enabled = 1";
        if (StringUtils.isNotBlank((CharSequence)this.codePrefix)) {
            sql = sql + " AND code like '" + this.codePrefix + "%'";
        }
        List<SequenceRule> rules = null;
        try {
            rules = this.jdbcExecutor.queryForList(sql, null, SequenceRule.class);
        }
        catch (Exception e) {
            this.noRuleTable = e.getMessage() != null && e.getMessage().contains("doesn't exist");
            return;
        }
        HashMap<String, SequenceRule> ruleMapping = new HashMap<String, SequenceRule>(rules.size());
        for (SequenceRule rule : rules) {
            if (!this.matchCodes.isEmpty() && !this.matchCodes.contains(rule.getCode())) continue;
            ruleMapping.put(rule.getCode(), rule);
        }
        this.sequenceRules.set(ruleMapping);
        for (SequenceRule rule : ruleMapping.values()) {
            String timeSequence = NONE_TIME_EXPRE;
            if (StringUtils.isNotBlank((CharSequence)rule.getTimeExpr())) {
                timeSequence = this.buildTimeExprSequence(rule.getTimeExpr());
            }
            String queueName = String.format(SEQUENCE_QUEUE_KEY_TPL, rule.getCode(), timeSequence);
            this.generateWithLock(rule, queueName, timeSequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWithLock(SequenceRule rule, String queueName, String timeSequence) {
        RedisDistributeLock lock = null;
        boolean getLocked = false;
        try {
            lock = new RedisDistributeLock("sequence.queue:" + rule.getCode());
            getLocked = lock.tryLock();
            if (getLocked) {
                this.procuceSequenceAndAddQueue(rule, timeSequence, queueName);
            }
        }
        finally {
            if (getLocked) {
                lock.unlock();
            }
        }
    }

    private boolean isCrossPeriodReset(SequenceRule rule, String queueName) {
        boolean isCrossPeriod;
        if (StringUtils.isBlank((CharSequence)rule.getTimeExpr())) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        if (rule.getTimeExpr().endsWith(SeqTimeExpr.MONTH.getExpr()) ? calendar.get(5) != calendar.getActualMinimum(5) : rule.getTimeExpr().endsWith(SeqTimeExpr.YEAR.getExpr()) && calendar.get(6) != calendar.getActualMinimum(6)) {
            return false;
        }
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        boolean bl = isCrossPeriod = hour == 0 && minute <= 1;
        if (isCrossPeriod) {
            isCrossPeriod = this.redisTemplate.hasKey((Object)queueName) == false;
        }
        return isCrossPeriod;
    }

    public void afterPropertiesSet() throws Exception {
        DataSource dataSource;
        me = this;
        try {
            dataSource = DataSourceGroups.getDataSource("sequence");
        }
        catch (MendmixBaseException e) {
            dataSource = this.defaultDataSource;
        }
        this.jdbcExecutor = new JdbcExecutor(dataSource);
        this.threshold = this.batchSize * 20 / 100;
        logger.info(">>>>>SequenceGenerateService inited -> taskInterval:{},batchSize:{},threshold:{}", new Object[]{taskInterval, this.batchSize, this.threshold});
    }

    @Override
    public long interval() {
        return taskInterval;
    }
}

