/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.dromara.mendmix.common.serializer.Serializer;

public class JavaSerializer
implements Serializer {
    @Override
    public String name() {
        return "java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object obj) throws IOException {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Object deserialize(byte[] bits) throws IOException {
        if (bits == null || bits.length == 0) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bits);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

