/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.dromara.mendmix.common.serializer.Serializer;

public class KryoPoolSerializer
implements Serializer {
    @Override
    public String name() {
        return "kryo_pool_ser";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        KryoHolder kryoHolder = null;
        if (obj == null) {
            throw new RuntimeException("obj can not be null");
        }
        try {
            kryoHolder = KryoPoolImpl.getInstance().get();
            kryoHolder.output.reset();
            kryoHolder.kryo.writeClassAndObject(kryoHolder.output, obj);
            byte[] byArray = kryoHolder.output.toBytes();
            return byArray;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (kryoHolder != null) {
                KryoPoolImpl.getInstance().offer(kryoHolder);
            }
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        KryoHolder kryoHolder = null;
        if (bytes == null) {
            throw new RuntimeException("bytes can not be null");
        }
        try {
            kryoHolder = KryoPoolImpl.getInstance().get();
            kryoHolder.input.setBuffer(bytes, 0, bytes.length);
            Object object = kryoHolder.kryo.readClassAndObject(kryoHolder.input);
            return object;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (kryoHolder != null) {
                KryoPoolImpl.getInstance().offer(kryoHolder);
            }
        }
    }

    public static class KryoPoolImpl
    implements KryoPool {
        private final Deque<KryoHolder> kryoHolderDeque = new ConcurrentLinkedDeque<KryoHolder>();

        private KryoPoolImpl() {
        }

        public static KryoPool getInstance() {
            return Singleton.pool;
        }

        @Override
        public KryoHolder get() {
            KryoHolder kryoHolder = this.kryoHolderDeque.pollFirst();
            return kryoHolder == null ? this.creatInstnce() : kryoHolder;
        }

        public KryoHolder creatInstnce() {
            Kryo kryo = new Kryo();
            kryo.setReferences(false);
            kryo.setRegistrationRequired(false);
            kryo.setWarnUnregisteredClasses(false);
            return new KryoHolder(kryo);
        }

        @Override
        public void offer(KryoHolder kryoHolder) {
            this.kryoHolderDeque.addLast(kryoHolder);
        }

        private static class Singleton {
            private static final KryoPool pool = new KryoPoolImpl();

            private Singleton() {
            }
        }
    }

    static interface KryoPool {
        public KryoHolder get();

        public void offer(KryoHolder var1);
    }

    private static class KryoHolder {
        private Kryo kryo;
        static final int BUFFER_SIZE = 1024;
        private Output output = new Output(1024, -1);
        private Input input = new Input();

        KryoHolder(Kryo kryo) {
            this.kryo = kryo;
        }
    }
}

