/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.serializer.Serializer;

public class KryoSerializer
implements Serializer {
    private static final String KRYO_INSTANCE_ID = "kryo";

    public static Kryo getKryo() {
        Kryo kryo = (Kryo)ThreadLocalContext.get(KRYO_INSTANCE_ID);
        if (kryo == null) {
            kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.setWarnUnregisteredClasses(false);
            ThreadLocalContext.set(KRYO_INSTANCE_ID, kryo);
        }
        return kryo;
    }

    @Override
    public String name() {
        return KRYO_INSTANCE_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object obj) throws IOException {
        try (Output output = null;){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            output = new Output((OutputStream)baos);
            KryoSerializer.getKryo().writeClassAndObject(output, obj);
            output.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(byte[] bits) throws IOException {
        if (bits == null || bits.length == 0) {
            return null;
        }
        try (Input ois = null;){
            ByteArrayInputStream bais = new ByteArrayInputStream(bits);
            ois = new Input((InputStream)bais);
            Object object = KryoSerializer.getKryo().readClassAndObject(ois);
            return object;
        }
    }
}

