/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dromara.mendmix.common.async.AsyncInitializer;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.task.SubTimerTask;
import org.dromara.mendmix.common.util.SpringAopHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
public class GlobalInternalScheduleService
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
AsyncInitializer {
    private static Logger log = LoggerFactory.getLogger((String)"global.internal.task");
    private ApplicationContext applicationContext;
    private List<SubTimerTaskStat> taskStats = new ArrayList<SubTimerTaskStat>();
    private ScheduledExecutorService executor;

    public GlobalInternalScheduleService() {
    }

    public GlobalInternalScheduleService(List<SubTimerTask> tasks) {
        for (SubTimerTask task : tasks) {
            this.taskStats.add(new SubTimerTaskStat(task));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        if (this.executor == null) {
            return;
        }
        this.executor.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        Map taskMap = this.applicationContext.getBeansOfType(SubTimerTask.class);
        if (taskMap != null) {
            for (SubTimerTask task : taskMap.values()) {
                this.taskStats.add(new SubTimerTaskStat(task));
            }
        }
        if (this.taskStats.isEmpty()) {
            return;
        }
        this.executor = Executors.newScheduledThreadPool(1, new StandardThreadExecutor.StandardThreadFactory("globalInternalScheduler"));
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (SubTimerTaskStat taskStat : GlobalInternalScheduleService.this.taskStats) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GlobalInternalScheduleService.this.execSubTimerTask(taskStat);
                }
            }
        }, 1000L, 5000L, TimeUnit.MILLISECONDS);
        log.info("MENDMIX-TRACE-LOGGGING-->> init GlobalInternalScheduleService finish -> subtaskNums:{}", (Object)this.taskStats.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execSubTimerTask(SubTimerTaskStat taskStat) {
        if (taskStat.running) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - taskStat.lastFireTime < taskStat.task.interval()) {
            return;
        }
        taskStat.running = true;
        try {
            if (log.isDebugEnabled()) {
                log.debug("MENDMIX-TRACE-LOGGGING-->> InternalSchedule[{}] execute Begin..", (Object)taskStat.taskName);
            }
            taskStat.task.doSchedule();
            taskStat.lastFireTime = currentTime;
        }
        catch (Exception e) {
            log.error("MENDMIX-TRACE-LOGGGING-->> InternalSchedule[" + taskStat.taskName + "] execute", (Throwable)e);
        }
        finally {
            taskStat.running = false;
        }
    }

    @Override
    public void doInitialize() {
        for (SubTimerTaskStat taskStat : this.taskStats) {
            if (taskStat.task.delay() > 0L) continue;
            this.execSubTimerTask(taskStat);
        }
    }

    private class SubTimerTaskStat {
        SubTimerTask task;
        String taskName;
        boolean running = false;
        long lastFireTime;

        public SubTimerTaskStat(SubTimerTask task) {
            this.task = task;
            try {
                this.taskName = SpringAopHelper.getTarget(task).getClass().getSimpleName();
            }
            catch (Exception e) {
                this.taskName = task.getClass().getSimpleName();
            }
            this.lastFireTime = task.delay() > 0L ? System.currentTimeMillis() + task.delay() : System.currentTimeMillis() - 86400000L;
        }
    }
}

