/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dromara.mendmix.common.json.serializer.DateConvertSerializer;
import org.dromara.mendmix.common.util.CachingFieldUtils;
import org.dromara.mendmix.common.util.DateUtils;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private static final String CLASS_PROP_NAME = "class";
    private static Map<String, Map<String, PropertyDescriptor>> cache = new ConcurrentHashMap<String, Map<String, PropertyDescriptor>>();
    private static Map<String, List<String>> fieldCache = new HashMap<String, List<String>>();
    private static List<String> dynaProxyClassKeys = Arrays.asList("JavassistProxyFactory$");
    private static List<String> jdkPackagePrefixs = Arrays.asList("java.");
    private static boolean ignoreNull = ResourceUtils.getBoolean("mendmix-cloud.beancopy.ignoreNull", true);
    private static boolean deepCopy = ResourceUtils.getBoolean("mendmix-cloud.beancopy.deepCopy", true);

    public static <T> T copy(Object src, T dest, boolean deepCopy, boolean ignoreNull) throws RuntimeException {
        if (src == null) {
            return null;
        }
        try {
            Class<?> destClass = dest.getClass();
            Map<String, PropertyDescriptor> srcDescriptors = BeanUtils.getCachePropertyDescriptors(src.getClass());
            Map<String, PropertyDescriptor> destDescriptors = BeanUtils.getCachePropertyDescriptors(destClass);
            Set<String> keys = destDescriptors.keySet();
            for (String key : keys) {
                PropertyDescriptor srcDescriptor = srcDescriptors.get(key);
                if (srcDescriptor == null) continue;
                PropertyDescriptor destDescriptor = destDescriptors.get(key);
                List<?> value = srcDescriptor.getReadMethod().invoke(src, new Object[0]);
                Class<?> propertyType = destDescriptor.getPropertyType();
                Method writeMethod = destDescriptor.getWriteMethod();
                String name = destDescriptor.getName();
                if (writeMethod == null) {
                    try {
                        writeMethod = destClass.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), destDescriptor.getPropertyType());
                        destDescriptor.setWriteMethod(writeMethod);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (writeMethod == null) continue;
                if (value != null) {
                    if (srcDescriptor.getPropertyType().isEnum() || BeanUtils.isSimpleDataType(srcDescriptor.getPropertyType())) {
                        if (propertyType != srcDescriptor.getPropertyType()) {
                            value = BeanUtils.toAdaptTypeValue(srcDescriptor.getPropertyType(), value, propertyType);
                        }
                    } else {
                        try {
                            if (List.class.isAssignableFrom(propertyType)) {
                                Class<?> distGenericType;
                                Class<?> srcGenericClass;
                                List srcList = value;
                                if (!(srcList == null || srcList.isEmpty() || BeanUtils.isSimpleDataType(srcGenericClass = srcList.get(0).getClass()) || (distGenericType = BeanUtils.getGenericType(destClass, name)) == null || !deepCopy && srcGenericClass == distGenericType)) {
                                    value = BeanUtils.copy(srcList, distGenericType);
                                }
                            } else if (deepCopy && !jdkPackagePrefixs.stream().anyMatch(prefix -> propertyType.getName().startsWith((String)prefix))) {
                                value = BeanUtils.copy((Object)value, propertyType);
                            }
                        }
                        catch (Exception e) {
                            logger.error("copy object[{}.{}]error:{}", new Object[]{src.getClass().getName(), name, ExceptionFormatUtils.buildExceptionMessages((Throwable)e, 3)});
                        }
                    }
                    writeMethod.invoke(dest, value);
                    continue;
                }
                if (ignoreNull) continue;
                try {
                    writeMethod.invoke(dest, value);
                }
                catch (Exception exception) {}
            }
            return dest;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T copy(Object src, T dest, boolean deepCopy) throws RuntimeException {
        return BeanUtils.copy(src, dest, deepCopy, ignoreNull);
    }

    public static <T> T merge(Object src, T dest) throws RuntimeException {
        return BeanUtils.copy(src, dest, deepCopy, true);
    }

    public static <T> T copy(Object src, T dest) throws RuntimeException {
        return BeanUtils.copy(src, dest, deepCopy, ignoreNull);
    }

    public static <T> List<T> copy(List<?> srcs, Class<T> destClass, boolean deepCopy) {
        if (srcs == null) {
            return new ArrayList();
        }
        ArrayList<T> dests = new ArrayList<T>(srcs.size());
        for (Object src : srcs) {
            dests.add(BeanUtils.copy(src, destClass, deepCopy));
        }
        return dests;
    }

    public static <T> List<T> copy(List<?> srcs, Class<T> destClass) {
        return BeanUtils.copy(srcs, destClass, deepCopy);
    }

    public static <T> T copy(Object src, Class<T> destClass, boolean deepCopy) throws RuntimeException {
        if (src == null) {
            return null;
        }
        try {
            T dest = destClass.newInstance();
            BeanUtils.copy(src, dest, deepCopy, ignoreNull);
            return dest;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T copy(Object src, Class<T> destClass) throws RuntimeException {
        return BeanUtils.copy(src, destClass, deepCopy);
    }

    public static void zeroWrapPropertiesToNull(Object bean, String ... excludeFields) throws RuntimeException {
        try {
            Map<String, PropertyDescriptor> srcDescriptors = BeanUtils.getCachePropertyDescriptors(bean.getClass());
            Set<String> keys = srcDescriptors.keySet();
            List<String> excludeFieldsList = null;
            if (excludeFields != null && excludeFields.length > 0 && StringUtils.isNotBlank((CharSequence)excludeFields[0])) {
                excludeFieldsList = Arrays.asList(excludeFields);
            }
            for (String key : keys) {
                PropertyDescriptor srcDescriptor = srcDescriptors.get(key);
                if (srcDescriptor == null || excludeFieldsList != null && excludeFieldsList.contains(key)) continue;
                Object value = srcDescriptor.getReadMethod().invoke(bean, new Object[0]);
                boolean isWrapType = srcDescriptor.getPropertyType() == Long.class || srcDescriptor.getPropertyType() == Integer.class || srcDescriptor.getPropertyType() == Short.class || srcDescriptor.getPropertyType() == Double.class || srcDescriptor.getPropertyType() == Float.class;
                if (!isWrapType || value == null || Integer.parseInt(value.toString()) != 0) continue;
                value = null;
                Method writeMethod = srcDescriptor.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object toAdaptTypeValue(Class<?> srcPropertyType, Object value, Class<?> distPropertyType) {
        if (distPropertyType == BigDecimal.class) {
            value = value == null ? BigDecimal.ZERO : new BigDecimal(value.toString().trim());
        } else if (distPropertyType == Byte.TYPE || distPropertyType == Byte.class) {
            value = value == null ? Byte.valueOf("0") : Byte.valueOf(value.toString().trim());
        } else if (distPropertyType == Short.TYPE || distPropertyType == Short.class) {
            value = value == null ? Short.valueOf("0") : Short.valueOf(value.toString().trim());
        } else if (distPropertyType == Integer.TYPE || distPropertyType == Integer.class) {
            value = srcPropertyType == Boolean.TYPE || srcPropertyType == Boolean.class ? Integer.valueOf(Boolean.parseBoolean(value.toString().trim()) ? 1 : 0) : (value == null ? Integer.valueOf("0") : Integer.valueOf(value.toString().trim()));
        } else if (distPropertyType == Double.TYPE || distPropertyType == Double.class) {
            value = value == null ? Double.valueOf("0") : Double.valueOf(value.toString().trim());
        } else if (distPropertyType == Date.class) {
            if (value != null) {
                if (srcPropertyType == String.class) {
                    value = DateUtils.parseDate(value.toString().trim());
                } else if (srcPropertyType == Long.class || srcPropertyType == Integer.class || srcPropertyType == Long.TYPE || srcPropertyType == Integer.TYPE) {
                    Long val = Long.valueOf(value.toString().trim());
                    value = val != 0L ? new Date(val) : null;
                }
            }
        } else if (distPropertyType == String.class && srcPropertyType != String.class) {
            if (value != null) {
                value = srcPropertyType == Date.class ? DateUtils.format((Date)value, new String[0]) : value.toString();
            }
        } else if (distPropertyType == Boolean.TYPE || distPropertyType == Boolean.class) {
            value = Boolean.parseBoolean(value.toString()) || "1".equals(value.toString());
        }
        return value;
    }

    public static Object toPrimitiveValue(String value, Class<?> propertyType) {
        Object result = value;
        if (propertyType == BigDecimal.class) {
            result = new BigDecimal(value);
        } else if (propertyType == Byte.TYPE || propertyType == Byte.class) {
            result = Byte.valueOf(value);
        } else if (propertyType == Short.TYPE || propertyType == Short.class) {
            result = Short.valueOf(value.toString());
        } else if (propertyType == Integer.TYPE || propertyType == Integer.class) {
            result = Integer.parseInt(value);
        } else if (propertyType == Double.TYPE || propertyType == Double.class) {
            result = Double.valueOf(value.toString());
        } else if (propertyType == Long.TYPE || propertyType == Long.class) {
            result = Long.valueOf(value.toString());
        } else if (propertyType == Date.class) {
            if (value != null) {
                result = DateUtils.parseDate(value);
            }
        } else if (propertyType == LocalDate.class) {
            if (value != null) {
                result = LocalDate.parse(value);
            }
        } else if (propertyType == Boolean.TYPE || propertyType == Boolean.class) {
            result = Boolean.parseBoolean(value) || "1".equals(value);
        }
        return result;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        String propertyName = null;
        try {
            T bean = clazz.newInstance();
            Map<String, PropertyDescriptor> descriptors = BeanUtils.getCachePropertyDescriptors(clazz);
            for (PropertyDescriptor descriptor : descriptors.values()) {
                Object object;
                propertyName = descriptor.getName();
                if (!map.containsKey(propertyName) || (object = map.get(propertyName)) == null) continue;
                if (descriptor.getPropertyType() != object.getClass() && !descriptor.getPropertyType().isAssignableFrom(object.getClass())) {
                    object = BeanUtils.toPrimitiveValue(object.toString(), descriptor.getPropertyType());
                }
                descriptor.getWriteMethod().invoke(bean, object);
            }
            return bean;
        }
        catch (Exception e) {
            logger.error("bean copy error for:class:{},property:{}", (Object)clazz.getName(), propertyName);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanUtils.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean recursive) {
        return BeanUtils.beanToMap(bean, recursive, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean recursive, boolean dateFormat) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            Map<String, PropertyDescriptor> descriptors = BeanUtils.getCachePropertyDescriptors(bean.getClass());
            for (PropertyDescriptor descriptor : descriptors.values()) {
                Method readMethod;
                Object result;
                String propertyName = descriptor.getName();
                if (CLASS_PROP_NAME.equalsIgnoreCase(propertyName) || (result = (readMethod = descriptor.getReadMethod()).invoke(bean, new Object[0])) == null) continue;
                String className = result.getClass().getName();
                if (dynaProxyClassKeys.stream().anyMatch(o -> className.contains((CharSequence)o))) continue;
                if (dateFormat && descriptor.getPropertyType() == Date.class) {
                    Field field = CachingFieldUtils.getField(bean.getClass(), propertyName);
                    if (field == null) continue;
                    if (field.isAnnotationPresent(JsonFormat.class)) {
                        JsonFormat jsonFormat = field.getAnnotation(JsonFormat.class);
                        result = DateUtils.format((Date)result, jsonFormat.pattern());
                    } else if (field.isAnnotationPresent(JsonSerialize.class)) {
                        Class jsonSerializer = field.getAnnotation(JsonSerialize.class).using();
                        if (jsonSerializer == DateConvertSerializer.class) {
                            result = DateUtils.format2DateStr((Date)result);
                        }
                    } else {
                        result = DateUtils.format((Date)result, new String[0]);
                    }
                    returnMap.put(propertyName, result);
                    continue;
                }
                if (BeanUtils.isSimpleDataType(result) || result instanceof Iterable) {
                    returnMap.put(propertyName, result);
                    continue;
                }
                if (recursive) {
                    returnMap.put(propertyName, BeanUtils.beanToMap(result, recursive, dateFormat));
                    continue;
                }
                returnMap.put(propertyName, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return returnMap;
    }

    public static void copy(Map<String, Object> src, Object dist) {
        if (src == null || src.isEmpty() || dist == null) {
            return;
        }
        try {
            Map<String, PropertyDescriptor> descriptors = BeanUtils.getCachePropertyDescriptors(dist.getClass());
            for (PropertyDescriptor descriptor : descriptors.values()) {
                Object value;
                String propertyName = descriptor.getName();
                if (CLASS_PROP_NAME.equalsIgnoreCase(propertyName) || !src.containsKey(propertyName) || (value = src.get(propertyName)) == null) continue;
                value = BeanUtils.toAdaptTypeValue(value.getClass(), value, descriptor.getPropertyType());
                descriptor.getWriteMethod().invoke(dist, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, PropertyDescriptor> getCachePropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        String canonicalName = clazz.getCanonicalName();
        Map<String, PropertyDescriptor> map = cache.get(canonicalName);
        if (map == null) {
            map = BeanUtils.doCacheClass(clazz, canonicalName);
        }
        return map;
    }

    private static synchronized Map<String, PropertyDescriptor> doCacheClass(Class<?> clazz, String canonicalName) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        if (cache.containsKey(canonicalName)) {
            return cache.get(canonicalName);
        }
        ConcurrentHashMap<String, PropertyDescriptor> map = new ConcurrentHashMap<String, PropertyDescriptor>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        BeanInfo srcBeanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor descriptor : descriptors = srcBeanInfo.getPropertyDescriptors()) {
            if (CLASS_PROP_NAME.equals(descriptor.getName()) || "serialVersionUID".equals(descriptor.getName())) continue;
            fieldNames.add(descriptor.getName());
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            String name = descriptor.getName();
            if (readMethod == null) {
                try {
                    readMethod = clazz.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
                    descriptor.setReadMethod(readMethod);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (writeMethod == null) {
                try {
                    writeMethod = clazz.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), descriptor.getPropertyType());
                    descriptor.setWriteMethod(writeMethod);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (readMethod == null || writeMethod == null) continue;
            map.put(descriptor.getName(), descriptor);
        }
        cache.put(canonicalName, map);
        fieldCache.put(canonicalName, fieldNames);
        return map;
    }

    public static Class<?> getFieldGenericType(Field field) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type type = parameterizedType.getActualTypeArguments()[0];
            return (Class)type;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T buildMockData(Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            List fields = FieldUtils.getAllFieldsList(clazz);
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.getType() == String.class) {
                    field.set(instance, "xxxx");
                    continue;
                }
                if (field.getType() == BigDecimal.class) {
                    field.set(instance, new BigDecimal(100));
                    continue;
                }
                if (field.getType() == Byte.TYPE || field.getType() == Byte.class) {
                    field.set(instance, (byte)1);
                    continue;
                }
                if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                    field.set(instance, (short)1);
                    continue;
                }
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    field.set(instance, 1);
                    continue;
                }
                if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                    field.set(instance, 1.0);
                    continue;
                }
                if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                    field.set(instance, true);
                    continue;
                }
                if (field.getType() == Date.class) {
                    field.set(instance, new Date());
                    continue;
                }
                if (field.getType() != List.class) continue;
                Class<?> fieldGenericType = BeanUtils.getFieldGenericType(field);
                ArrayList list = new ArrayList();
                for (int i = 0; i < 2; ++i) {
                    list.add(BeanUtils.buildMockData(fieldGenericType));
                }
                field.set(instance, list);
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSimpleDataType(Object o) {
        if (o == null) {
            return true;
        }
        return BeanUtils.isSimpleDataType(o.getClass());
    }

    public static boolean isSimpleDataType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class);
    }

    private static Class<?> getGenericType(Class<?> objectClass, String fieldName) {
        try {
            Field field = FieldUtils.getField(objectClass, (String)fieldName, (boolean)true);
            Type genericType = field.getGenericType();
            if (null == genericType) {
                return null;
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
                return actualTypeArgument;
            }
        }
        catch (Exception e) {
            logger.debug("getGenericType error for class:{},property:{},error:{}", new Object[]{objectClass.getName(), fieldName, ExceptionFormatUtils.buildExceptionMessages(e)});
        }
        return null;
    }
}

