/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;

public class CachingFieldUtils {
    private static Map<String, Map<String, Field>> fieldCacheHub = new HashMap<String, Map<String, Field>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getField(Class<?> cls, String fieldName) {
        String className = cls.getName();
        try {
            Field fileld;
            if (!fieldCacheHub.containsKey(className) || !fieldCacheHub.get(className).containsKey(fieldName)) {
                Map<String, Map<String, Field>> map = fieldCacheHub;
                synchronized (map) {
                    fileld = FieldUtils.getField(cls, (String)fieldName, (boolean)true);
                    if (!fieldCacheHub.containsKey(className)) {
                        fieldCacheHub.put(className, new HashMap());
                    }
                    fieldCacheHub.get(className).put(fieldName, fileld);
                }
            } else {
                fileld = fieldCacheHub.get(className).get(fieldName);
            }
            return fileld;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object readField(Object target, String fieldName) {
        if (target == null) {
            return null;
        }
        Field field = CachingFieldUtils.getField(target.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeField(Object target, String fieldName, Object value) {
        if (target == null) {
            return;
        }
        Field field = CachingFieldUtils.getField(target.getClass(), fieldName);
        if (field == null) {
            return;
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

