/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner {
    private static final String SUFFIX_CLASS = ".class";

    public static List<String> scan(String packageName) {
        Enumeration<URL> urls;
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        packageName = packageName.replace('.', '/');
        try {
            urls = classloader.getResources(packageName);
            if (!urls.hasMoreElements()) {
                System.err.println("Unable to find any resources for package '" + packageName + "'");
            }
        }
        catch (IOException ioe) {
            System.err.println("Could not read package: " + packageName);
            return new ArrayList<String>(0);
        }
        List<String> packagePathList = ClassScanner.findInPackageWithUrls(packageName, urls);
        ArrayList<String> result = new ArrayList<String>(packagePathList.size());
        for (String path : packagePathList) {
            if (path.contains("$")) continue;
            String className = path.substring(0, path.lastIndexOf(".")).replaceAll("\\/", ".");
            result.add(className);
        }
        return result;
    }

    static List<String> findInPackageWithUrls(String packageName, Enumeration<URL> urls) {
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            try {
                URL url = urls.nextElement();
                String urlPath = url.getPath();
                if (urlPath.lastIndexOf(33) > 0) {
                    if ((urlPath = urlPath.substring(0, urlPath.lastIndexOf(33))).startsWith("/")) {
                        urlPath = "file:" + urlPath;
                    }
                } else if (!urlPath.startsWith("file:")) {
                    urlPath = "file:" + urlPath;
                }
                File file = null;
                try {
                    URL fileURL = new URL(urlPath);
                    if ("file".equals(fileURL.getProtocol().toLowerCase())) {
                        file = new File(fileURL.toURI());
                    } else {
                        System.out.println("Skipping non file classpath element [ " + urlPath + " ]");
                    }
                }
                catch (URISyntaxException e) {
                    file = new File(urlPath.substring("file:".length()));
                }
                if (file != null && file.isDirectory()) {
                    localClsssOrPkgs.addAll(ClassScanner.loadImplementationsInDirectory(packageName, file));
                    continue;
                }
                if (file == null) continue;
                localClsssOrPkgs.addAll(ClassScanner.loadImplementationsInJar(file));
            }
            catch (IOException ioe) {
                System.err.println("could not read entries: " + ioe);
            }
        }
        return localClsssOrPkgs;
    }

    static List<String> loadImplementationsInDirectory(String parent, File location) {
        File[] files = location.listFiles();
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        for (File file : files) {
            String packageOrClass = parent == null || parent.length() == 0 ? file.getName() : parent + "/" + file.getName();
            if (file.isDirectory()) {
                localClsssOrPkgs.addAll(ClassScanner.loadImplementationsInDirectory(packageOrClass, file));
                continue;
            }
            if ("".equals(parent) && file.getName().endsWith(".jar")) {
                localClsssOrPkgs.addAll(ClassScanner.loadImplementationsInJar(file));
                continue;
            }
            String pkg = packageOrClass;
            if (!pkg.endsWith(SUFFIX_CLASS)) continue;
            localClsssOrPkgs.add(pkg);
        }
        return localClsssOrPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> loadImplementationsInJar(File file) {
        ArrayList<String> localClsssOrPkgs = new ArrayList<String>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(SUFFIX_CLASS)) continue;
                localClsssOrPkgs.add(name);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return localClsssOrPkgs;
    }

    public static void main(String[] args) {
        List<String> list = ClassScanner.scan("org.dromara.mendmix.common");
        System.out.println(list);
    }
}

