/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final String TIME_00_00_00 = " 00:00:00";
    private static final String TIME_23_59_59 = " 23:59:59";
    private static final String[] weekDays = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_PATTERN = "HH:mm";

    public static Date parseDate(String dateStr) {
        SimpleDateFormat format = null;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        String _dateStr = dateStr.trim();
        try {
            if (_dateStr.matches("\\d{1,2}[A-Z]{3}")) {
                _dateStr = _dateStr + (Calendar.getInstance().get(1) - 2000);
            }
            if (_dateStr.matches("\\d{1,2}[A-Z]{3}\\d{2}")) {
                format = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
            } else if (_dateStr.matches("\\d{1,2}[A-Z]{3}\\d{4}.*")) {
                _dateStr = _dateStr.replaceAll("[^0-9A-Z]", "").concat("000000").substring(0, 15);
                format = new SimpleDateFormat("ddMMMyyyyHHmmss", Locale.ENGLISH);
            } else {
                StringBuffer sb = new StringBuffer(_dateStr);
                String[] tempArr = _dateStr.split("\\s+");
                if ((tempArr = tempArr[0].split("-|\\/")).length == 3) {
                    if (tempArr[1].length() == 1) {
                        sb.insert(5, "0");
                    }
                    if (tempArr[2].length() == 1) {
                        sb.insert(8, "0");
                    }
                }
                if ((_dateStr = sb.append("000000").toString().replaceAll("[^0-9]", "").substring(0, 14)).matches("\\d{14}")) {
                    format = new SimpleDateFormat("yyyyMMddHHmmss");
                }
            }
            Date date = format.parse(_dateStr);
            return date;
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u5b57\u7b26[" + dateStr + "]");
        }
    }

    public static Date parseDate(String dateStr, String pattern) {
        try {
            SimpleDateFormat format = null;
            if (StringUtils.isBlank((CharSequence)dateStr)) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                format = new SimpleDateFormat(pattern);
                return format.parse(dateStr);
            }
            return DateUtils.parseDate(dateStr);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u5b57\u7b26[" + dateStr + "]");
        }
    }

    public static Date getDayBegin(Date date) {
        String format = DateFormatUtils.format((Date)date, (String)DATE_PATTERN);
        return DateUtils.parseDate(format.concat(TIME_00_00_00));
    }

    public static Date getDayEnd(Date date) {
        String format = DateFormatUtils.format((Date)date, (String)DATE_PATTERN);
        return DateUtils.parseDate(format.concat(TIME_23_59_59));
    }

    public static Date timestamp2Date(Date date) {
        return DateUtils.formatDate(date, DATE_PATTERN);
    }

    public static String format2ddMMMyy(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
        return format.format(date).toUpperCase();
    }

    public static String format2ddMMMyy(String dateStr) {
        SimpleDateFormat format = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
        return format.format(DateUtils.parseDate(dateStr)).toUpperCase();
    }

    public static String formatDateStr(String dateStr, String ... patterns) {
        String pattern = TIMESTAMP_PATTERN;
        if (patterns != null && patterns.length > 0 && StringUtils.isNotBlank((CharSequence)patterns[0])) {
            pattern = patterns[0];
        }
        return DateFormatUtils.format((Date)DateUtils.parseDate(dateStr), (String)pattern);
    }

    public static String format(Date date, String ... patterns) {
        if (date == null) {
            return "";
        }
        String pattern = TIMESTAMP_PATTERN;
        if (patterns != null && patterns.length > 0 && StringUtils.isNotBlank((CharSequence)patterns[0])) {
            pattern = patterns[0];
        }
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String format2DateStr(Date date) {
        return DateUtils.format(date, DATE_PATTERN);
    }

    public static Date formatDate(Date orig, String ... patterns) {
        String pattern = TIMESTAMP_PATTERN;
        if (patterns != null && patterns.length > 0 && StringUtils.isNotBlank((CharSequence)patterns[0])) {
            pattern = patterns[0];
        }
        return DateUtils.parseDate(DateFormatUtils.format((Date)orig, (String)pattern));
    }

    public static long getDiffSeconds(Date d1, Date d2) {
        return Math.abs((d2.getTime() - d1.getTime()) / 1000L);
    }

    public static long getDiffMinutes(Date d1, Date d2) {
        long diffSeconds = DateUtils.getDiffSeconds(d1, d2);
        return diffSeconds / 60L;
    }

    public static long getDiffDay(Date d1, Date d2) {
        long between = Math.abs((d2.getTime() - d1.getTime()) / 1000L);
        long day = between / 60L / 60L / 24L;
        return (long)Math.floor(day);
    }

    public static Date lastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int value = cal.getActualMaximum(5);
        cal.set(5, value);
        return cal.getTime();
    }

    public static Date firstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int value = cal.getActualMinimum(5);
        cal.set(5, value);
        return cal.getTime();
    }

    public static int getDiffMonth(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        return (endCalendar.get(1) - startCalendar.get(1)) * 12 + endCalendar.get(2) - startCalendar.get(2);
    }

    public static String formatTimeConsumingInfo(long startPoint) {
        StringBuffer buff = new StringBuffer();
        long totalMilTimes = System.currentTimeMillis() - startPoint;
        int hour = (int)Math.floor(totalMilTimes / 3600000L);
        int mi = (int)Math.floor(totalMilTimes / 60000L);
        int se = (int)Math.floor((totalMilTimes - (long)(60000 * mi)) / 1000L);
        if (hour > 0) {
            buff.append(hour).append("\u5c0f\u65f6");
        }
        if (mi > 0) {
            buff.append(mi).append("\u5206");
        }
        if (hour == 0) {
            buff.append(se).append("\u79d2");
        }
        return buff.toString();
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static String getDateWeekEnName(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static Date firstDayOfWeek(Date date) {
        ZoneId zoneId = ZoneId.systemDefault();
        long timeMills = LocalDate.now(Clock.fixed(Instant.ofEpochMilli(date.getTime()), zoneId)).with(DayOfWeek.MONDAY).atStartOfDay(zoneId).toInstant().toEpochMilli();
        return new Date(timeMills);
    }

    public static Date lastDayOfWeek(Date date) {
        ZoneId zoneId = ZoneId.systemDefault();
        long timeMills = LocalDate.now(Clock.fixed(Instant.ofEpochMilli(date.getTime()), zoneId)).with(DayOfWeek.SUNDAY).atStartOfDay(zoneId).toInstant().toEpochMilli();
        return new Date(timeMills);
    }
}

