/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.AuthUser;

public class ExceptionFormatUtils {
    private static boolean filterMode = true;
    private static int showLines = 5;
    private static List<String> filterKeys = Arrays.asList("org.dromara.mendmix", "org.apache.ibatis", "org.springframework", "org.apache.kafka");

    public static void setFilterMode(boolean filterMode) {
        ExceptionFormatUtils.filterMode = filterMode;
    }

    public static void setShowLines(int showLines) {
        ExceptionFormatUtils.showLines = showLines;
    }

    public static void setFilterKeys(List<String> filterKeys) {
        ExceptionFormatUtils.filterKeys = filterKeys;
    }

    public static String buildLogHeader(String actionKey, Serializable bizKey) {
        AuthUser currentUser;
        String tenantId;
        StringBuilder builder = new StringBuilder();
        builder.append(actionKey);
        builder.append("<bizKey:").append(bizKey).append(">");
        String requestId = CurrentRuntimeContext.getRequestId();
        if (requestId != null) {
            builder.append("<requestId:").append(requestId).append(">");
        }
        if ((tenantId = CurrentRuntimeContext.getTenantId(false)) != null) {
            builder.append("<tenantId:").append(tenantId).append(">");
        }
        if ((currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            builder.append("<currentUser:").append(currentUser.getName()).append(">");
        }
        return builder.toString();
    }

    public static String buildLogTail() {
        AuthUser currentUser;
        String tenantId;
        String systemId;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        String requestUrl = ThreadLocalContext.getStringValue("_context-request-url");
        if (requestUrl != null) {
            builder.append("<uri:").append(requestUrl).append(">");
        }
        if ((systemId = CurrentRuntimeContext.getSystemId()) != null) {
            builder.append("<systemId:").append(systemId).append(">");
        }
        if ((tenantId = CurrentRuntimeContext.getTenantId(false)) != null) {
            builder.append("<tenantId:").append(tenantId).append(">");
        }
        if ((currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            builder.append("<currentUser:").append(currentUser.getName()).append(">");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String buildExceptionMessages(Throwable throwable) {
        return ExceptionFormatUtils.buildExceptionMessages(throwable, filterMode);
    }

    public static String buildExceptionMessages(Throwable throwable, int showLines) {
        String[] traces = ExceptionUtils.getRootCauseStackTrace((Throwable)throwable);
        try {
            StringBuilder sb = new StringBuilder();
            showLines = showLines >= traces.length ? traces.length : showLines;
            for (int i = 0; i < showLines; ++i) {
                sb.append(traces[i]).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public static String buildExceptionMessages(Throwable throwable, boolean filterMode) {
        if (!filterMode) {
            return ExceptionUtils.getStackTrace((Throwable)throwable);
        }
        String[] traces = ExceptionUtils.getRootCauseStackTrace((Throwable)throwable);
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < traces.length; ++i) {
                String line = traces[i];
                if (StringUtils.isBlank((CharSequence)line) || showLines <= i && !filterKeys.stream().anyMatch(o -> line.contains((CharSequence)o))) continue;
                sb.append(line).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public static Exception wrapExtraExceptionMessages(String sourceName, Exception e) {
        String contextVal;
        if (!(e instanceof MendmixBaseException) || Thread.currentThread().getName().contains("http-")) {
            return e;
        }
        String requestUrl = ThreadLocalContext.getStringValue("_context-request-url");
        HashMap<String, String> contextParam = new HashMap<String, String>(3);
        contextParam.put("sourceName", sourceName);
        if (requestUrl != null) {
            contextParam.put("requestUrl", requestUrl);
        }
        if ((contextVal = CurrentRuntimeContext.getRequestId()) != null) {
            contextParam.put("requestId", contextVal);
        }
        if ((contextVal = CurrentRuntimeContext.getSystemId()) != null) {
            contextParam.put("systemId", contextVal);
        }
        if ((contextVal = CurrentRuntimeContext.getTenantId()) != null) {
            contextParam.put("tenantId", contextVal);
        }
        if ((contextVal = CurrentRuntimeContext.getContextVal("x-forwarded-service-chain", false)) != null) {
            contextParam.put("serviceChain", contextVal);
        }
        ((MendmixBaseException)e).setContextParam(contextParam);
        return e;
    }
}

