/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.http.ApacheHttpClient;
import org.dromara.mendmix.common.http.HostMappingHolder;
import org.dromara.mendmix.common.http.HttpClientProvider;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.http.JdkHttpClient;
import org.dromara.mendmix.common.http.OkHttp3Client;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.common.httpclient");
    private static HttpClientProvider provider;

    private HttpUtils() {
    }

    public static HttpResponseEntity get(String url) {
        return HttpUtils.execute(HttpRequestEntity.get(url));
    }

    public static HttpResponseEntity postJson(String url, String json) {
        HttpRequestEntity requestEntity = HttpRequestEntity.post(url).body(json);
        return HttpUtils.execute(requestEntity);
    }

    public static HttpResponseEntity postJson(String url, String json, String charset) {
        String contentType = "application/json; charset=" + charset;
        HttpRequestEntity requestEntity = HttpRequestEntity.post(url).body(json).contentType(contentType);
        return HttpUtils.execute(requestEntity);
    }

    public static HttpResponseEntity execute(HttpRequestEntity requestEntity) {
        StringBuilder logBuilder = null;
        try {
            if (StringUtils.isBlank((CharSequence)requestEntity.getUri())) {
                throw new IllegalArgumentException("request uri is missing");
            }
            requestEntity.uri(HostMappingHolder.resolveUrl(requestEntity.getUri()));
            if (logger.isDebugEnabled()) {
                logBuilder = requestEntity.buildRequestLog();
            }
            HttpResponseEntity resp = provider.execute(requestEntity);
            if (logBuilder != null) {
                resp.appendResponseLog(logBuilder);
            }
            return resp;
        }
        catch (IOException e) {
            if (logBuilder != null) {
                logBuilder.append("\nexception:").append(e.getMessage());
                logBuilder.append("\n---------------backend request trace end--------------------");
            }
            if (e instanceof ConnectException) {
                return new HttpResponseEntity(503, "ConnectException:" + e.getMessage());
            }
            if (e instanceof UnknownHostException) {
                return new HttpResponseEntity(400, "UnknownHostException:" + e.getMessage());
            }
            return new HttpResponseEntity(400, e.getMessage());
        }
    }

    public static HttpResponseEntity uploadFile(String url, String fieldName, File file) {
        HttpRequestEntity requestEntity = HttpRequestEntity.post(url);
        requestEntity.fileParam(fieldName, file);
        return HttpUtils.execute(requestEntity);
    }

    public static String downloadFile(String fileURL, String saveDir) {
        HttpURLConnection httpConn = null;
        FileOutputStream outputStream = null;
        try {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
                }
                InputStream inputStream = httpConn.getInputStream();
                String saveFilePath = saveDir + File.separator + fileName;
                outputStream = new FileOutputStream(saveFilePath);
                int bytesRead = -1;
                byte[] buffer = new byte[2048];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                String string = saveFilePath;
                return string;
            }
            try {
                throw new MendmixBaseException(responseCode, "\u4e0b\u8f7d\u5931\u8d25");
            }
            catch (IOException e) {
                throw new MendmixBaseException(500, "\u4e0b\u8f7d\u5931\u8d25", e);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        String providerType = ResourceUtils.getProperty("mendmix-cloud.httpclient.provider");
        try {
            if (providerType == null || providerType.equalsIgnoreCase("httpClient")) {
                Class.forName("org.apache.http.impl.client.CloseableHttpClient");
                Class.forName("org.apache.http.entity.mime.MultipartEntityBuilder");
                provider = new ApacheHttpClient();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (provider == null && (providerType == null || providerType.equalsIgnoreCase("okHttp3"))) {
                Class.forName("okhttp3.OkHttpClient");
                provider = new OkHttp3Client();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (provider == null) {
            provider = new JdkHttpClient();
        }
        System.out.println("init HttpClientProvider:" + provider.getClass().getSimpleName());
    }
}

