/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.HttpUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class IpUtils {
    public static final String HEADER_FROWARDED_FOR = "x-forwarded-for";
    public static final String LOCAL_BACK_IP = "127.0.0.1";
    public static final String LOCAL_HOST = "localhost";
    public static final String UNKNOWN = "unknown";
    private static volatile String localIp;
    private static Pattern ipPattern;
    private static final String[] lanIpPrefixs;

    public static boolean isIp(String ipAddr) {
        if (StringUtils.isBlank((CharSequence)ipAddr)) {
            return false;
        }
        return ipPattern.matcher(ipAddr).matches();
    }

    public static boolean isInnerIp(String ipAddr) {
        if (StringUtils.isBlank((CharSequence)ipAddr) || !IpUtils.isIp(ipAddr)) {
            return false;
        }
        if (ipAddr.startsWith(lanIpPrefixs[0])) {
            return true;
        }
        if (ipAddr.startsWith(lanIpPrefixs[1])) {
            return true;
        }
        if (ipAddr.startsWith(lanIpPrefixs[2])) {
            return true;
        }
        if (ipAddr.startsWith(lanIpPrefixs[3])) {
            return true;
        }
        if (ipAddr.startsWith(lanIpPrefixs[4])) {
            try {
                int secondSub = Integer.parseInt(StringUtils.splitByWholeSeparator((String)ipAddr, (String)".")[1]);
                return secondSub >= 16 && secondSub <= 31;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader(HEADER_FROWARDED_FOR);
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) && (ip = request.getRemoteAddr()).equals(LOCAL_BACK_IP)) {
            ip = IpUtils.getLocalIpAddr();
        }
        if (ip != null && ip.length() > 15) {
            String[] ips;
            for (String _ip : ips = StringUtils.split((String)ip, (String)",")) {
                ip = StringUtils.trimToNull((String)_ip);
                if (UNKNOWN.equalsIgnoreCase(ip)) continue;
                return ip;
            }
        }
        if (ip != null && ip.contains(":")) {
            ip = LOCAL_BACK_IP;
        } else if (ip == null) {
            ip = request.getRemoteHost();
        }
        return ip;
    }

    public static String getIpAddr(ServerHttpRequest request) {
        String ip = request.getHeaders().getFirst(HEADER_FROWARDED_FOR);
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeaders().getFirst("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeaders().getFirst("WL-Proxy-Client-IP");
        }
        if (ip != null && ip.length() > 15) {
            String _ip;
            String[] ips;
            String[] stringArray = ips = StringUtils.split((String)ip, (String)",");
            int n = stringArray.length;
            for (int i = 0; i < n && UNKNOWN.equalsIgnoreCase(ip = StringUtils.trimToNull((String)(_ip = stringArray[i]))); ++i) {
            }
        }
        if (ip == null) {
            ip = request.getRemoteAddress().getAddress().getHostAddress();
        }
        if (ip.contains(":")) {
            ip = LOCAL_BACK_IP;
        }
        return ip;
    }

    public static String getLocalIpAddr() {
        if (localIp != null) {
            return localIp;
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            String currentIp = null;
            block4: while (en.hasMoreElements()) {
                NetworkInterface i = en.nextElement();
                Enumeration<InetAddress> en2 = i.getInetAddresses();
                while (en2.hasMoreElements()) {
                    InetAddress addr = en2.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address) || !IpUtils.isInnerIp(currentIp = addr.getHostAddress())) continue;
                    localIp = currentIp;
                    break block4;
                }
            }
            if (localIp == null) {
                localIp = currentIp;
            }
        }
        catch (Exception en) {
            // empty catch block
        }
        if (localIp == null) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
                localIp = inet.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return localIp;
    }

    public static String ipToLocation(String ip) {
        if (IpUtils.isInnerIp(ip)) {
            return null;
        }
        try {
            String url = "http://ip.taobao.com/service/getIpInfo.php?ip=" + ip;
            String content = HttpUtils.get(url).getBody();
            Map resp = JsonUtils.toObject(content, Map.class);
            if ("0".equals(String.valueOf(resp.get("code")))) {
                String city = (resp = (Map)resp.get("data")).get("city") == null ? "" : resp.get("city").toString();
                return city;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void main(String[] args) {
    }

    static {
        ipPattern = Pattern.compile("(\\d{1,3}\\.)+\\d{1,3}");
        lanIpPrefixs = new String[]{"127.", "192.168", "10.", "100.64.", "172."};
    }
}

