/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.json.CompsiteDateFormat;
import org.dromara.mendmix.common.json.deserializer.StringTrimDeserializer;
import org.dromara.mendmix.common.json.serializer.BigNumberToStringSerializer;
import org.dromara.mendmix.common.json.serializer.BooleanCompositeDeserializer;
import org.dromara.mendmix.common.json.serializer.BooleanToBitSerializer;
import org.dromara.mendmix.common.util.ResourceUtils;

public class JsonUtils {
    private static ObjectMapper jsonMapper = null;
    private static String JSON_OBJECT_PREFIX = "{";
    private static String JSON_ARRAY_PREFIX = "[";
    private static SimpleModule simpleModule = new SimpleModule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectMapper getMapper() {
        if (jsonMapper != null) {
            return jsonMapper;
        }
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (jsonMapper != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return jsonMapper;
            }
            ObjectMapper jsonMapper = new ObjectMapper();
            JsonUtils.setCustomConfigure(jsonMapper);
            JsonUtils.jsonMapper = jsonMapper;
            // ** MonitorExit[var0] (shouldn't be in output)
            return JsonUtils.jsonMapper;
        }
    }

    public static void setJsonMapper(ObjectMapper jsonMapper) {
        JsonUtils.jsonMapper = jsonMapper;
    }

    public static void setCustomConfigure(ObjectMapper jsonMapper) {
        jsonMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        jsonMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
        jsonMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        jsonMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        jsonMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        jsonMapper.disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        jsonMapper.setDateFormat((DateFormat)CompsiteDateFormat.singleton());
        jsonMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        if (ResourceUtils.getBoolean("mendmix-cloud.jackson.ignoreNull", true)) {
            jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        } else {
            jsonMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
        if (ResourceUtils.getBoolean("mendmix-cloud.jackson.deserialize.emptyToNull", false)) {
            jsonMapper.getDeserializationConfig().with(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        }
        if (ResourceUtils.getBoolean("mendmix-cloud.jackson.deserialize.dateFormatUsingTimezone", false)) {
            // empty if block
        }
        simpleModule.addDeserializer(Boolean.class, (JsonDeserializer)BooleanCompositeDeserializer.instance);
        if (ResourceUtils.getBoolean("mendmix-cloud.jackson.bigNumberToString", false)) {
            simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)BigNumberToStringSerializer.instance);
            simpleModule.addSerializer(BigInteger.class, (JsonSerializer)BigNumberToStringSerializer.instance);
            simpleModule.addSerializer(Long.class, (JsonSerializer)BigNumberToStringSerializer.instance);
        }
        if (ResourceUtils.getBoolean("mendmix-cloud.jackson.deserialize.emptyStringFieldToNull", false)) {
            simpleModule.addDeserializer(String.class, (JsonDeserializer)StringTrimDeserializer.instance);
        }
        if (ResourceUtils.getBoolean("mendmix-cloud.jackson.booleanToBit", false)) {
            simpleModule.addSerializer(Boolean.class, (JsonSerializer)BooleanToBitSerializer.instance);
        }
        jsonMapper.registerModule((Module)simpleModule);
    }

    public static <T> void addDeserializer(Class<T> type, JsonDeserializer<? extends T> deser) {
        simpleModule.addDeserializer(type, deser);
    }

    public static <T> void addSerializer(Class<? extends T> type, JsonSerializer<T> ser) {
        simpleModule.addSerializer(type, ser);
    }

    public static boolean isJsonString(String str) {
        return JsonUtils.isJsonObjectString(str) || JsonUtils.isJsonArrayString(str);
    }

    public static boolean isJsonObjectString(String str) {
        return StringUtils.trimToEmpty((String)str).startsWith(JSON_OBJECT_PREFIX);
    }

    public static boolean isJsonArrayString(String str) {
        return StringUtils.trimToEmpty((String)str).startsWith(JSON_ARRAY_PREFIX);
    }

    public static String toJson(Object object) {
        try {
            return JsonUtils.getMapper().writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toJsonBytes(Object object) {
        return JsonUtils.toJson(object).getBytes(StandardCharsets.UTF_8);
    }

    public static String toJsonIgnoreNullField(Object object) {
        return JsonUtils.toJson(object);
    }

    public static String toPrettyJson(Object object) {
        try {
            return JsonUtils.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtils.getMapper().readValue(jsonString, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String jsonString, TypeReference<T> valueTypeRef) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtils.getMapper().readValue(jsonString, valueTypeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> toList(String jsonString, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        JavaType javaType = JsonUtils.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz});
        return (List)JsonUtils.toObject(jsonString, javaType);
    }

    public static <K, V> Map<K, V> toHashMap(String jsonString, Class<K> keyType, Class<V> valueType) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        JavaType javaType = JsonUtils.getMapper().getTypeFactory().constructParametricType(HashMap.class, new Class[]{keyType, valueType});
        return (Map)JsonUtils.toObject(jsonString, javaType);
    }

    public static <V> Map<String, V> toHashMap(String jsonString, Class<V> valueType) {
        return JsonUtils.toHashMap(jsonString, String.class, valueType);
    }

    public static Map<String, Object> toHashMap(String jsonString) {
        return JsonUtils.toHashMap(jsonString, String.class, Object.class);
    }

    public static <T> T toObject(String jsonString, JavaType javaType) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtils.getMapper().readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode getNode(String jsonString, String nodeName) {
        JsonNode jsonNode = JsonUtils.toJsonNode(jsonString);
        return nodeName == null ? jsonNode : jsonNode.get(nodeName);
    }

    public static JsonNode toJsonNode(String jsonString) {
        try {
            JsonNode node = JsonUtils.getMapper().readTree(jsonString);
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayNode toJsonArrayNode(String jsonString) {
        try {
            JsonNode node = JsonUtils.getMapper().readTree(jsonString);
            return (ArrayNode)node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJsonNodeValue(String jsonString, String attrs) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        return JsonUtils.getJsonNodeValue(JsonUtils.getNode(jsonString, null), attrs);
    }

    public static <T> T toObject(JsonNode node, Class<T> clazz) {
        return JsonUtils.toObject(node.toString(), clazz);
    }

    public static <T> List<T> toList(ArrayNode node, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            result.add(JsonUtils.toObject(node.get(i), clazz));
        }
        return result;
    }

    public static String getJsonNodeValue(JsonNode node, String attrs) {
        ArrayNode arrayNode;
        int index = attrs.indexOf(".");
        JsonNode subNode = null;
        if (index == -1) {
            if (node != null) {
                ArrayNode arrayNode2;
                subNode = node instanceof ArrayNode ? ((arrayNode2 = (ArrayNode)node).isEmpty() ? null : arrayNode2.get(0).get(attrs)) : node.get(attrs);
                if (subNode == null) {
                    return null;
                }
                if (subNode instanceof ValueNode) {
                    return subNode.asText();
                }
                return subNode.toString();
            }
            return null;
        }
        String s1 = attrs.substring(0, index);
        String s2 = attrs.substring(index + 1);
        subNode = node instanceof ArrayNode ? ((arrayNode = (ArrayNode)node).isEmpty() ? null : arrayNode.get(0).get(s1)) : node.get(s1);
        return JsonUtils.getJsonNodeValue(subNode, s2);
    }
}

