/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.BeanUtils;

public class ParameterUtils {
    public static final String CONTACT_STR = "&";
    public static final String EQUALS_STR = "=";
    public static final String SPLIT_STR = ",";
    public static final String JSON_SUFFIX = "}";
    public static final String JSON_PREFIX = "{";
    public static final String BRACKET_PREFIX = "[";
    public static final String BRACKET_SUFFIX = "]";
    public static final String PARAM_SIGN = "sign";
    public static final String PARAM_SIGN_TYPE = "signType";
    public static final String PARAM_DATA = "data";

    public static Map<String, Object> queryParamsToMap(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration e = request.getParameterNames();
        StringBuilder tmpbuff = new StringBuilder();
        if (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = request.getParameterValues(name);
                if (values.length == 1) {
                    if (!StringUtils.isNotBlank((CharSequence)values[0])) continue;
                    params.put(name, values[0]);
                    continue;
                }
                tmpbuff.setLength(0);
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)values[i])) continue;
                    tmpbuff.append(values[i].trim()).append(SPLIT_STR);
                }
                if (tmpbuff.length() <= 0) continue;
                tmpbuff.deleteCharAt(tmpbuff.length() - 1);
                params.put(name, tmpbuff.toString());
            }
        }
        return params;
    }

    public static Map<String, Object> queryParamsToMap(String queryParams) {
        String[] paramSegs;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String param : paramSegs = StringUtils.split((String)queryParams, (String)CONTACT_STR)) {
            String[] kv = StringUtils.split((String)param, (String)EQUALS_STR);
            if (kv.length == 1 || StringUtils.isBlank((CharSequence)kv[1])) continue;
            map.put(kv[0].trim(), kv[1].trim());
        }
        return map;
    }

    public static String objectToQueryParams(Object param) {
        Map<String, Object> map = param instanceof Map ? (Map<String, Object>)param : BeanUtils.beanToMap(param);
        return ParameterUtils.mapToQueryParams(map);
    }

    public static String mapToQueryParams(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Object value;
            if (PARAM_SIGN_TYPE.equals(key) || PARAM_SIGN.equals(key) || (value = param.get(key)) == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
            if (value instanceof Map) {
                if ((value = ParameterUtils.mapToQueryParams((Map)value)) != null) {
                    value = JSON_PREFIX + value + JSON_SUFFIX;
                }
            } else if (value instanceof Iterable) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append(BRACKET_PREFIX);
                for (Object object : (Iterable)value) {
                    if (BeanUtils.isSimpleDataType(object)) {
                        sb1.append(object).append(SPLIT_STR);
                        continue;
                    }
                    sb1.append(JSON_PREFIX).append(ParameterUtils.objectToQueryParams(object)).append(JSON_SUFFIX).append(SPLIT_STR);
                }
                if (sb1.length() == 1) {
                    value = null;
                } else if (sb1.length() > 0) {
                    sb1.deleteCharAt(sb1.length() - 1);
                    sb1.append(BRACKET_SUFFIX);
                    value = sb1.toString();
                }
            } else if (!BeanUtils.isSimpleDataType(value) && (value = ParameterUtils.objectToQueryParams(value)) != null) {
                value = JSON_PREFIX + value + JSON_SUFFIX;
            }
            if (value == null) continue;
            sb.append(key).append(EQUALS_STR).append(value).append(CONTACT_STR);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

