/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.StringConverter;
import org.yaml.snakeyaml.Yaml;

public final class ResourceUtils {
    private static List<String> fileNames;
    private static List<String> fileExtensions;
    public static String CONFIG_DELIMITERS;
    public static final String NULL_VALUE_PLACEHOLDER = "_NULL_PLACEHOLDER_";
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private static String profile;
    private static String profileFile;
    private static Properties profileProperties;
    private static final Properties allProperties;

    private static void loadLocalConfigs() {
        try {
            String addtionalLocation;
            String customLocation;
            profile = System.getProperty("spring.profiles.active");
            URL url = Thread.currentThread().getContextClassLoader().getResource("");
            if (url == null) {
                url = ResourceUtils.class.getResource("");
            }
            if (StringUtils.isNotBlank((CharSequence)(customLocation = System.getProperty("spring.config.location")))) {
                System.out.println(String.format(">>using customLocation:%s", customLocation));
                Properties properties = new Properties();
                FileReader fileReader = new FileReader(customLocation);
                properties.load(fileReader);
                allProperties.putAll((Map<?, ?>)properties);
                return;
            }
            HashMap<String, List<String>> allFileMap = new HashMap<String, List<String>>();
            if (url != null) {
                if (url.getProtocol().equals("file")) {
                    String path = URLDecoder.decode(url.getPath(), "UTF-8");
                    File parent = new File(path);
                    if (!parent.exists()) {
                        System.err.println("<startup-logging> loadPropertiesFromFile_error,dir not found");
                    } else {
                        ResourceUtils.loadPropertiesFromFile(parent);
                    }
                } else if (url.getProtocol().equals("jar")) {
                    ResourceUtils.loadPropertiesFromJarFile(url, allFileMap);
                }
            }
            ArrayList<Object> keys = new ArrayList<Object>(allProperties.keySet());
            for (Object e : keys) {
                String value;
                if (e == null || allProperties.getProperty(e.toString()) == null || !allProperties.getProperty(e.toString()).contains(PLACEHOLDER_PREFIX) || !StringUtils.isNotBlank((CharSequence)(value = ResourceUtils.replaceRefValue(allProperties.getProperty(e.toString()))))) continue;
                allProperties.setProperty(e.toString(), value);
            }
            if (profileFile != null) {
                allProperties.putAll((Map<?, ?>)profileProperties);
                System.out.println("<startup-logging>   load properties from file:" + profileFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(addtionalLocation = System.getProperty("spring.config.additional-location")))) {
                System.out.println(String.format(">>add addtional configs:%s", addtionalLocation));
                Properties properties = new Properties();
                FileReader fileReader = new FileReader(addtionalLocation);
                properties.load(fileReader);
                allProperties.putAll((Map<?, ?>)properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadPropertiesFromJarFile(URL url, Map<String, List<String>> allFileMap) throws UnsupportedEncodingException, IOException {
        String jarFilePath = url.getFile();
        if (jarFilePath.contains("war!")) {
            jarFilePath = StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"war!")[0] + "war";
        } else if (jarFilePath.contains("jar!")) {
            jarFilePath = StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"jar!")[0] + "jar";
        }
        jarFilePath = jarFilePath.substring("file:".length());
        jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
        JarFile jarFile = new JarFile(jarFilePath);
        String fileExt = null;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String fileName = entry.getName().contains("/") ? entry.getName().substring(entry.getName().lastIndexOf("/") + 1) : entry.getName().substring(entry.getName().lastIndexOf(File.separator) + 1);
            if (!fileNames.stream().anyMatch(prefix -> fileName.startsWith((String)prefix)) || !fileExtensions.stream().anyMatch(suffix -> fileName.endsWith((String)suffix))) continue;
            fileExt = entry.getName().substring(entry.getName().lastIndexOf("."));
            if (!allFileMap.containsKey(fileExt)) {
                allFileMap.put(fileExt, new ArrayList());
            }
            allFileMap.get(fileExt).add(entry.getName());
        }
        Set<String> fileExts = allFileMap.keySet();
        for (String key : fileExts) {
            ResourceUtils.parseConfigSortFiles(allFileMap.get(key), key, jarFile);
        }
        jarFile.close();
    }

    private static void loadPropertiesFromFile(File parent) throws FileNotFoundException, IOException {
        HashMap allFileMap = new HashMap();
        File[] files = parent.listFiles();
        if (files == null) {
            return;
        }
        String fileExt = null;
        for (File file : files) {
            if (file.isDirectory() || !fileNames.stream().anyMatch(prefix -> file.getName().startsWith((String)prefix)) || !fileExtensions.stream().anyMatch(suffix -> file.getName().endsWith((String)suffix))) continue;
            String path = file.getPath();
            fileExt = path.substring(path.lastIndexOf("."));
            if (!allFileMap.containsKey(fileExt)) {
                allFileMap.put(fileExt, new ArrayList());
            }
            ((List)allFileMap.get(fileExt)).add(path);
        }
        Set fileExts = allFileMap.keySet();
        for (String key : fileExts) {
            ResourceUtils.parseConfigSortFiles((List)allFileMap.get(key), key, null);
        }
    }

    private static void parseConfigSortFiles(List<String> fileList, String fileExt, JarFile jarFile) throws IOException, FileNotFoundException {
        if (fileList.size() == 1) {
            Properties p = ResourceUtils.parseToProperties(fileList.get(0), jarFile);
            allProperties.putAll((Map<?, ?>)p);
            System.out.println("<startup-logging>   load properties from file:" + fileList.get(0));
        } else if (fileList.size() > 1) {
            LinkedHashMap<String, Properties> filePropMap = new LinkedHashMap<String, Properties>(fileList.size());
            for (String file : fileList) {
                Properties p = ResourceUtils.parseToProperties(file, jarFile);
                filePropMap.put(file, p);
                if (profile != null || !p.containsKey("spring.profiles.active")) continue;
                profile = ResourceUtils.replaceRefValue(p.getProperty("spring.profiles.active"));
            }
            if (profile != null) {
                String suffix = "-" + profile + fileExt;
                for (String file : fileList) {
                    if (!file.endsWith(suffix)) continue;
                    profileFile = file;
                    profileProperties = (Properties)filePropMap.get(file);
                }
            }
            for (String file : fileList) {
                String fileName = file.contains("/") ? file.substring(file.lastIndexOf("/") + 1) : file.substring(file.lastIndexOf(File.separator) + 1);
                if (fileName.contains("-")) continue;
                allProperties.putAll((Map<?, ?>)((Map)filePropMap.get(file)));
                System.out.println("<startup-logging>   load properties from file:" + file);
            }
        }
    }

    private static Properties parseToProperties(String path, JarFile jarFile) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        Yaml yaml = null;
        if (path.endsWith(".yaml") || path.endsWith(".yml")) {
            yaml = new Yaml();
        }
        if (jarFile == null) {
            FileReader fileReader = new FileReader(path);
            if (yaml == null) {
                properties.load(fileReader);
            } else {
                Map map = (Map)yaml.load((Reader)fileReader);
                ResourceUtils.parseYamlInnerMap(null, properties, map);
            }
            try {
                fileReader.close();
            }
            catch (Exception map) {}
        } else {
            InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(path));
            if (yaml == null) {
                properties.load(inputStream);
            } else {
                Map map = (Map)yaml.load(inputStream);
                ResourceUtils.parseYamlInnerMap(null, properties, map);
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Properties getAllProperties() {
        return ResourceUtils.getAllProperties(null);
    }

    public static Properties getAllProperties(String prefix) {
        return ResourceUtils.getAllProperties(prefix, true);
    }

    public static Properties getAllProperties(String keyPattern, boolean matchPrefix) {
        Properties properties = new Properties();
        Set<Map.Entry<Object, Object>> entrySet = allProperties.entrySet();
        boolean match = false;
        for (Map.Entry<Object, Object> entry : entrySet) {
            match = StringUtils.isBlank((CharSequence)keyPattern);
            if (!match) {
                match = matchPrefix ? entry.getKey().toString().startsWith(keyPattern) : entry.getKey().toString().matches(keyPattern);
            }
            if (!match) continue;
            String value = ResourceUtils.replaceRefValue(entry.getValue().toString());
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    public static String getProperty(String key) {
        return ResourceUtils.getProperty(key, null);
    }

    public static String getAnyProperty(String ... keys) {
        String value;
        for (String key : keys) {
            if (StringUtils.isBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)(value = System.getProperty(key)))) continue;
            return value;
        }
        for (String key : keys) {
            value = ResourceUtils.getProperty(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String getAndValidateProperty(String key) {
        String value = ResourceUtils.getProperty(key, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(String.format("Property for key:%s not exists", key));
        }
        return value;
    }

    public static String getProperty(String key, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        String value = System.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return StringUtils.trimToNull((String)value);
        }
        value = System.getenv(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return StringUtils.trimToNull((String)value);
        }
        value = allProperties.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = ResourceUtils.replaceRefValue(value);
            return StringUtils.trimToNull((String)value);
        }
        return defaultValue;
    }

    public static int getInt(String key) {
        return ResourceUtils.getInt(key, 0);
    }

    public static int getInt(String key, int defalutValue) {
        String v = ResourceUtils.getProperty(key);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return defalutValue;
    }

    public static long getLong(String key) {
        return ResourceUtils.getLong(key, 0L);
    }

    public static long getLong(String key, long defalutValue) {
        String v = ResourceUtils.getProperty(key);
        if (v != null) {
            return Long.parseLong(v);
        }
        return defalutValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(ResourceUtils.getProperty(key));
    }

    public static boolean getBoolean(String key, boolean defalutValue) {
        String value = ResourceUtils.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defalutValue;
    }

    public static List<String> getList(String key) {
        String value = ResourceUtils.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return new ArrayList<String>(0);
        }
        StringTokenizer st = new StringTokenizer(value, CONFIG_DELIMITERS);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!StringUtils.isNotBlank((CharSequence)token)) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static Map<String, String> getMappingValues(String prefix) {
        Properties properties = ResourceUtils.getAllProperties(prefix);
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String value = StringUtils.trimToNull((String)Objects.toString(entry.getValue(), null));
            if (value == null) continue;
            String key = entry.getKey().toString();
            if (key.contains("[")) {
                String[] arr = StringUtils.split((String)key, (String)"[]");
                result.put(arr[1], value);
                continue;
            }
            int index = prefix.endsWith(".") ? prefix.length() : prefix.length() + 1;
            result.put(key.substring(index), value);
        }
        return result;
    }

    public static synchronized void merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String refValue;
            Object value = entry.getValue();
            if (value == null || !StringUtils.isNotBlank((CharSequence)(refValue = ResourceUtils.replaceRefValue(value.toString())))) continue;
            allProperties.setProperty(entry.getKey().toString(), refValue);
        }
    }

    public static synchronized void merge(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            String refValue = ResourceUtils.replaceRefValue(properties.get(key).toString());
            if (!StringUtils.isNotBlank((CharSequence)refValue)) continue;
            allProperties.setProperty(key, refValue);
        }
    }

    public static synchronized void add(String key, String value) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)(value = ResourceUtils.replaceRefValue(value)))) {
            allProperties.setProperty(key, value);
        }
    }

    public static boolean containsProperty(String key) {
        return System.getProperties().containsKey(key) || allProperties.containsKey(key);
    }

    public static boolean containsAnyProperty(String ... keys) {
        for (String key : keys) {
            if (!ResourceUtils.containsProperty(key)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getPropertyNames(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<Object> keys = allProperties.keys();
        while (keys.hasMoreElements()) {
            Object r = keys.nextElement();
            if (!r.toString().startsWith(prefix)) continue;
            result.add(r.toString());
        }
        return result;
    }

    @Deprecated
    public static <T> T getBean(String prefix, Class<T> clazz) {
        return ResourceUtils.getConfigObject(prefix, clazz);
    }

    public static <T> T getConfigObject(String prefix, Class<T> clazz) {
        try {
            Field[] fields;
            T config = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                String configKey = prefix + field.getName();
                if (!ResourceUtils.containsProperty(configKey)) continue;
                Object configValue = field.getType() == Integer.TYPE || field.getType() == Integer.class ? Integer.valueOf(Integer.parseInt(ResourceUtils.getProperty(configKey))) : (field.getType() == Long.TYPE || field.getType() == Long.class ? Long.valueOf(Long.parseLong(ResourceUtils.getProperty(configKey))) : (field.getType() == Double.TYPE || field.getType() == Double.class ? Double.valueOf(Double.parseDouble(ResourceUtils.getProperty(configKey))) : (field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(ResourceUtils.getProperty(configKey))) : (List.class.isAssignableFrom(field.getType()) ? ResourceUtils.getList(configKey) : ResourceUtils.getProperty(configKey)))));
                try {
                    field.set(config, configValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> getConfigObjects(String prefix, Class<T> clazz) {
        ArrayList<T> configs = new ArrayList<T>();
        int index = 0;
        while (true) {
            String withIndexPrefix = prefix + "[" + index + "].";
            if (!allProperties.keySet().stream().anyMatch(o -> o.toString().contains(withIndexPrefix))) break;
            configs.add(ResourceUtils.getConfigObject(withIndexPrefix, clazz));
            ++index;
        }
        return configs;
    }

    public static synchronized void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        allProperties.remove(key);
    }

    private static String replaceRefValue(Properties properties, String value) {
        if (!value.contains(PLACEHOLDER_PREFIX)) {
            return value;
        }
        String[] segments = value.split("\\$\\{");
        StringBuilder finalValue = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            String seg = StringUtils.trimToNull((String)segments[i]);
            if (StringUtils.isBlank((CharSequence)seg)) continue;
            if (seg.contains(PLACEHOLDER_SUFFIX)) {
                String refValue;
                String refKey = seg.substring(0, seg.indexOf(PLACEHOLDER_SUFFIX)).trim();
                String withBraceString = null;
                if (seg.contains("{")) {
                    withBraceString = seg.substring(seg.indexOf(PLACEHOLDER_SUFFIX) + 1);
                }
                String defaultValue = null;
                int defaultValSpliterIndex = refKey.indexOf(":");
                if (defaultValSpliterIndex > 0) {
                    defaultValue = refKey.substring(defaultValSpliterIndex + 1);
                    refKey = refKey.substring(0, defaultValSpliterIndex);
                }
                if (StringUtils.isBlank((CharSequence)(refValue = System.getProperty(refKey)))) {
                    refValue = System.getenv(refKey);
                }
                if (StringUtils.isBlank((CharSequence)refValue)) {
                    refValue = properties.getProperty(refKey);
                }
                if (StringUtils.isBlank((CharSequence)refValue)) {
                    refValue = defaultValue;
                }
                if (StringUtils.isBlank((CharSequence)refValue)) {
                    finalValue.append(PLACEHOLDER_PREFIX + refKey + PLACEHOLDER_SUFFIX);
                } else {
                    finalValue.append(refValue);
                }
                if (withBraceString != null) {
                    finalValue.append(withBraceString);
                    continue;
                }
                String[] segments2 = seg.split("\\}");
                if (segments2.length != 2) continue;
                finalValue.append(segments2[1]);
                continue;
            }
            finalValue.append(seg);
        }
        return finalValue.toString();
    }

    public static void printAllConfigs(List<String> hiddenKeys) {
        ArrayList<String> sortKeys = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> entrySet = allProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = entry.getKey().toString();
            if (hiddenKeys != null && hiddenKeys.contains(key)) continue;
            sortKeys.add(key);
        }
        Collections.sort(sortKeys);
        System.out.println(">>merge effectivec configs:");
        for (String key : sortKeys) {
            String value = ResourceUtils.getProperty(key);
            value = StringConverter.hideSensitiveKeyValue(key, value);
            System.out.println(String.format(" - %s = %s", key, value));
        }
    }

    public static String replaceRefValue(String value) {
        return ResourceUtils.replaceRefValue(allProperties, value);
    }

    private static void parseYamlInnerMap(String keyPrefix, Properties result, Map<String, Object> yamlData) {
        if (yamlData == null) {
            return;
        }
        for (String key : yamlData.keySet()) {
            String currentKey;
            String string = currentKey = keyPrefix == null ? key.toString() : keyPrefix + "." + key.toString();
            Object value = yamlData.get(key);
            if (value == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
            if (value instanceof List) {
                int index = 0;
                for (Object subValue : (List)value) {
                    if (index > 0) {
                        currentKey = currentKey.substring(0, currentKey.lastIndexOf("["));
                    }
                    currentKey = currentKey + "[" + index + "]";
                    if (subValue instanceof Map) {
                        ResourceUtils.parseYamlInnerMap(currentKey, result, (Map)subValue);
                    } else {
                        result.setProperty(currentKey, subValue.toString());
                    }
                    ++index;
                }
                continue;
            }
            if (value instanceof Map) {
                ResourceUtils.parseYamlInnerMap(currentKey, result, (Map)value);
                continue;
            }
            result.setProperty(currentKey, value.toString());
        }
    }

    static {
        fileExtensions = Arrays.asList(".properties", ".yaml", ".yml");
        CONFIG_DELIMITERS = ",; \t\n";
        allProperties = new Properties();
        String propVal = System.getProperty("mendmix-cloud.configs", "application,bootstrap");
        fileNames = Arrays.asList(propVal.split(","));
        ResourceUtils.loadLocalConfigs();
    }
}

