/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SafeStringUtils {
    private static List<String> sensitiveKeys = new ArrayList<String>(Arrays.asList("password", "key", "secret", "token", "credentials"));

    public static String hideSensitiveKeyValue(String key, String value) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
            return "";
        }
        if (key.endsWith(".enabled")) {
            return value;
        }
        boolean is = false;
        for (String k : sensitiveKeys) {
            is = key.toLowerCase().contains(k);
            if (!is) continue;
            break;
        }
        return is ? SafeStringUtils.getDesensitizedValue(value) : value;
    }

    public static String getDesensitizedValue(String value) {
        int length = value.length();
        if (length <= 2) {
            return value;
        }
        int partLen = length / 3;
        StringBuilder builder = new StringBuilder();
        builder.append(value.substring(0, partLen));
        int asteriskNums = partLen;
        if (partLen <= 3 && length > partLen * 3) {
            asteriskNums = partLen + 1;
        }
        for (int i = 0; i < asteriskNums; ++i) {
            builder.append("*");
        }
        builder.append(value.substring(partLen + asteriskNums));
        return builder.toString();
    }
}

