/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import org.apache.commons.lang3.Validate;
import org.dromara.mendmix.common.crypt.AesWrapper;
import org.dromara.mendmix.common.util.ResourceUtils;

public class SimpleCryptUtils {
    public static final AesWrapper aesWrapper;

    public static String encrypt(String plaintext) {
        return aesWrapper.encrypt(plaintext);
    }

    public static String decrypt(String ciphertext) {
        return aesWrapper.decrypt(ciphertext);
    }

    public static void main(String[] args) {
        String ciphertext = SimpleCryptUtils.encrypt("hello");
        System.out.println("ciphertext:" + ciphertext);
        String plaintext = SimpleCryptUtils.decrypt(ciphertext);
        System.out.println("plaintext:" + plaintext);
    }

    static {
        String cryptKey = ResourceUtils.getProperty("mendmix-cloud.crypto.cryptKey");
        Validate.notBlank((CharSequence)cryptKey, (String)"config[mendmix.crypto.cryptKey] is missing", (Object[])new Object[0]);
        aesWrapper = new AesWrapper(cryptKey);
    }
}

