/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.nio.charset.Charset;

public class StringCharsetUtils {
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset GBK = Charset.forName("GBK");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");

    public static boolean isCharset(String str, Charset charset) {
        try {
            return str.equals(new String(str.getBytes(charset), charset));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String convertCharset(String str, Charset toCharset) {
        if (StringCharsetUtils.isCharset(str, toCharset)) {
            return str;
        }
        if (StringCharsetUtils.isCharset(str, UTF_8)) {
            return StringCharsetUtils.convertCharset(str, UTF_8, toCharset);
        }
        if (StringCharsetUtils.isCharset(str, GBK)) {
            return StringCharsetUtils.convertCharset(str, UTF_8, toCharset);
        }
        if (StringCharsetUtils.isCharset(str, ISO_8859_1)) {
            return StringCharsetUtils.convertCharset(str, UTF_8, toCharset);
        }
        return str;
    }

    public static String convertCharset(String str, Charset fromCharset, Charset toCharset) {
        if (str != null) {
            byte[] bs = str.getBytes(fromCharset);
            return new String(bs, toCharset);
        }
        return null;
    }
}

