/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StringConverter {
    private static List<String> sensitiveKeys = new ArrayList<String>(Arrays.asList("password", "key", "secret", "token", "credentials"));
    private static String[] paddingzeros = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};

    public static String hideSensitiveKeyValue(String key, String value) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
            return "";
        }
        if (key.endsWith(".enabled")) {
            return value;
        }
        boolean is = false;
        for (String k : sensitiveKeys) {
            is = key.toLowerCase().contains(k);
            if (!is) continue;
            break;
        }
        return is ? StringConverter.getDesensitizedValue(value) : value;
    }

    public static String getDesensitizedValue(String value) {
        int length = value.length();
        if (length <= 2) {
            return value;
        }
        int partLen = length / 3;
        StringBuilder builder = new StringBuilder();
        builder.append(value.substring(0, partLen));
        int asteriskNums = partLen;
        if (partLen <= 3 && length > partLen * 3) {
            asteriskNums = partLen + 1;
        }
        for (int i = 0; i < asteriskNums; ++i) {
            builder.append("*");
        }
        builder.append(value.substring(partLen + asteriskNums));
        return builder.toString();
    }

    public static String toCamelCase(String underlineStr) {
        if (underlineStr == null) {
            return null;
        }
        if (!underlineStr.contains("_")) {
            return underlineStr;
        }
        char[] charArray = underlineStr.toCharArray();
        boolean underlineBefore = false;
        StringBuffer buffer = new StringBuffer();
        int l = charArray.length;
        for (int i = 0; i < l; ++i) {
            if (charArray[i] == '_') {
                underlineBefore = true;
                continue;
            }
            if (underlineBefore) {
                int n = i;
                char c = (char)(charArray[n] - 32);
                charArray[n] = c;
                buffer.append(c);
                underlineBefore = false;
                continue;
            }
            buffer.append(charArray[i]);
        }
        return buffer.toString();
    }

    public static String toUnderlineCase(String camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        char[] charArray = camelCaseStr.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int l = charArray.length;
        for (int i = 0; i < l; ++i) {
            if (charArray[i] >= 'A' && charArray[i] <= 'Z') {
                int n = i;
                char c = (char)(charArray[n] + 32);
                charArray[n] = c;
                buffer.append("_").append(c);
                continue;
            }
            buffer.append(charArray[i]);
        }
        return buffer.toString();
    }

    public static String paddingZeros(String str, int expectLength) {
        int len = expectLength - str.length();
        if (len > 0) {
            str = paddingzeros[len] + str;
        }
        return str;
    }

    public static void main(String[] args) {
        System.out.println(StringConverter.toCamelCase("userName"));
        System.out.println(StringConverter.toCamelCase("user_name"));
        System.out.println(StringConverter.toUnderlineCase("userName"));
    }
}

