/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.crypt.Base58;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.SimpleCryptUtils;

public class TokenGenerator {
    private static final String LINE_THROUGH = "-";
    private static final int EXPIRE = 180000;

    public static String generateFrom(String base) {
        String str = DigestUtils.md5(base);
        return new String(Base58.encode(str.getBytes()));
    }

    public static String generate(String ... prefixs) {
        String str = StringUtils.replace((String)UUID.randomUUID().toString(), (String)LINE_THROUGH, (String)"");
        if (prefixs != null && prefixs.length > 0 && StringUtils.isNotBlank((CharSequence)prefixs[0])) {
            str = prefixs[0].concat(str);
        }
        return str;
    }

    public static String generateWithSign() {
        String timeString = String.valueOf(System.currentTimeMillis() + 180000L);
        String str = DigestUtils.md5Short(UUID.randomUUID().toString()).concat(timeString);
        return SimpleCryptUtils.encrypt(str);
    }

    public static long validate(String token, boolean validateExpire) {
        long expiredAt;
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new MendmixBaseException(400, "token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date date = new Date();
        try {
            expiredAt = Long.parseLong(SimpleCryptUtils.decrypt(token).substring(6));
        }
        catch (Exception e) {
            throw new MendmixBaseException(403, "token\u683c\u5f0f\u9519\u8bef");
        }
        if (validateExpire && date.getTime() > expiredAt) {
            throw new MendmixBaseException(403, "token\u5df2\u8fc7\u671f");
        }
        return expiredAt;
    }

    public static void main(String[] args) {
        String token = TokenGenerator.generateWithSign();
        System.out.println(token);
        TokenGenerator.validate(token, true);
    }
}

