/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.util.HttpUtils;
import org.dromara.mendmix.common.util.IpUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.TokenGenerator;

public class WebUtils {
    private static final String POINT = ".";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private static final String MULTIPART = "multipart/";
    private static List<String> doubleDomainSuffixs = Arrays.asList(".com.cn", ".org.cn", ".net.cn");
    private static List<String> internalDomains = ResourceUtils.getList("internal.dns.domains");
    static boolean reported = false;

    public static boolean isJsonRequest(HttpServletRequest request) {
        return request.getHeader("x-requested-with") != null && XML_HTTP_REQUEST.equalsIgnoreCase(request.getHeader("x-requested-with").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void responseOutJson(HttpServletResponse response, String json) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void responseOutHtml(HttpServletResponse response, String html) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(html);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void responseOutJsonp(HttpServletResponse response, String callbackFunName, Object jsonObject) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain; charset=utf-8");
        PrintWriter out = null;
        String json = jsonObject instanceof String ? jsonObject.toString() : JsonUtils.toJson(jsonObject);
        String content = callbackFunName + "(" + json + ")";
        try {
            out = response.getWriter();
            out.append(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getRootDomain(HttpServletRequest request) {
        String host = request.getHeader("x-forwarded-host");
        if (StringUtils.isBlank((CharSequence)host)) {
            host = request.getServerName();
        }
        return WebUtils.parseHostRootDomain(host);
    }

    public static String getRootDomain(String url) {
        String host = WebUtils.getDomain(url);
        return WebUtils.parseHostRootDomain(host);
    }

    private static String parseHostRootDomain(String host) {
        if (IpUtils.isIp(host) || "localhost".equals(host)) {
            return host;
        }
        String[] segs = StringUtils.split((String)host, (String)POINT);
        int len = segs.length;
        if (doubleDomainSuffixs.stream().anyMatch(e -> host.endsWith((String)e))) {
            return segs[len - 3] + POINT + segs[len - 2] + POINT + segs[len - 1];
        }
        return segs[len - 2] + POINT + segs[len - 1];
    }

    public static String getDomain(String url) {
        String[] urlSegs = StringUtils.split((String)url, (String)"/");
        return urlSegs[1];
    }

    public static String getOriginDomain(HttpServletRequest request) {
        String originUrl = request.getHeader("Origin");
        if (originUrl == null) {
            originUrl = request.getHeader("Referer");
        }
        if (originUrl != null) {
            return WebUtils.getDomain(originUrl);
        }
        return request.getServerName();
    }

    public static String getBaseUrl(String url) {
        String[] segs = StringUtils.split((String)url, (String)"/");
        return segs[0] + "//" + segs[1];
    }

    public static String getBaseUrl(HttpServletRequest request) {
        return WebUtils.getBaseUrl(request, true);
    }

    public static String getBaseUrl(HttpServletRequest request, boolean withContextPath) {
        String baseUrl = null;
        String schame = request.getHeader("x-forwarded-proto");
        String host = request.getHeader("x-forwarded-host");
        String prefix = request.getHeader("x-forwarded-prefix");
        if (StringUtils.isBlank((CharSequence)host)) {
            String[] segs = StringUtils.split((String)request.getRequestURL().toString(), (String)"/");
            baseUrl = segs[0] + "//" + segs[1];
        } else {
            if (StringUtils.isBlank((CharSequence)schame)) {
                String port = request.getHeader("x-forwarded-port");
                schame = "443".equals(port) ? "https://" : "http://";
            } else {
                if (schame.contains(",")) {
                    schame = StringUtils.split((String)schame, (String)",")[0];
                }
                schame = schame + "://";
            }
            if (host.contains(",")) {
                host = StringUtils.split((String)host, (String)",")[0];
            }
            baseUrl = schame + host + StringUtils.trimToEmpty((String)prefix);
        }
        if (withContextPath && StringUtils.isNotBlank((CharSequence)request.getContextPath())) {
            baseUrl = baseUrl + request.getContextPath();
        }
        return baseUrl;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (!HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return (contentType = contentType.toLowerCase(Locale.ENGLISH)).startsWith(MULTIPART) || "application/octet-stream".equals(contentType);
    }

    public static boolean isInternalRequest(HttpServletRequest request) {
        String clientIp;
        String headerValue = request.getHeader("x-internal-request");
        if (Boolean.parseBoolean(headerValue)) {
            try {
                String authCode = request.getHeader("x-invoke-token");
                TokenGenerator.validate(authCode, true);
                return true;
            }
            catch (Exception authCode) {
                // empty catch block
            }
        }
        if (Boolean.parseBoolean(headerValue = request.getHeader("x-invoker-is-gateway"))) {
            try {
                String authCode = request.getHeader("x-invoke-token");
                TokenGenerator.validate(authCode, true);
                return false;
            }
            catch (Exception authCode) {
                // empty catch block
            }
        }
        if ((clientIp = request.getHeader("x-real-ip")) == null) {
            clientIp = IpUtils.getIpAddr(request);
        }
        if (IpUtils.isInnerIp(clientIp)) {
            return true;
        }
        boolean isInner = IpUtils.isInnerIp(request.getServerName());
        if (!isInner && !internalDomains.isEmpty()) {
            isInner = internalDomains.stream().anyMatch(domain -> request.getServerName().endsWith((String)domain));
        }
        return isInner;
    }

    public static void whoReport() {
        if (reported || !Thread.currentThread().getName().contains("http-")) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String packageName = ResourceUtils.getProperty("mendmix.application.base-package");
        if (packageName == null) {
            packageName = ResourceUtils.getAnyProperty("mybatis.mapper-package", "mybatis.type-aliases-package", "mendmix.task.scanPackages");
        }
        if (StringUtils.isBlank((CharSequence)packageName)) {
            try {
                URL url = Thread.currentThread().getContextClassLoader().getResource("");
                if (url != null && url.getProtocol().equals("file")) {
                    packageName = URLDecoder.decode(url.getPath(), "UTF-8");
                }
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)packageName)) {
            reported = true;
            return;
        }
        params.put("packageName", packageName);
        final String json = JsonUtils.toJson(params);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpResponseEntity httpResponseEntity = HttpUtils.postJson("https://www.jeesuite.com/active/report", json);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        reported = true;
    }

    public static void printRequest(HttpServletRequest request) {
        System.out.println("============Request start==============");
        System.out.println("uri:" + request.getRequestURI());
        System.out.println("method:" + request.getMethod());
        System.out.println("clientIP:" + IpUtils.getIpAddr(request));
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            System.out.println(String.format("Header %s = %s", headerName, request.getHeader(headerName)));
        }
        System.out.println("============Request end==============");
    }
}

