/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.model.KeyValuePair;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.WebUtils;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.api.SystemInfoApi;
import org.dromara.mendmix.gateway.model.BizSystem;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.gateway.model.BizSystemPortal;
import org.dromara.mendmix.gateway.model.CompositeModule;
import org.dromara.mendmix.gateway.model.SubSystem;
import org.dromara.mendmix.gateway.task.ModuleApiRefreshTask;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;

public class CurrentSystemHolder {
    private static Logger log = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private static boolean globalRouteEnabled = ResourceUtils.getBoolean((String)"mendmix-cloud.global-route.enabled", (boolean)true);
    private static boolean remoteRouteEnabled = ResourceUtils.getBoolean((String)"mendmix-cloud.remote-route.enabled", (boolean)true);
    private static boolean multiSystemMode = ResourceUtils.getBoolean((String)"mendmix-cloud.proxy.multi-system.enabled", (boolean)false);
    private static AtomicReference<LocalCacheHub> localCacheHubRef = new AtomicReference();
    private static Map<String, String> systemIdOrCodeRelMapping = new HashMap<String, String>();

    public static BizSystem getSystem() {
        return CurrentSystemHolder.localCacheHubRef.get().mainSystem;
    }

    public static List<BizSystem> getSystems() {
        return CurrentSystemHolder.localCacheHubRef.get().systems;
    }

    public static String validateSystemId(String systemIdOrCode) {
        return CurrentSystemHolder.validateSystemId(systemIdOrCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateSystemId(String systemIdOrCode, boolean subSystem) {
        if (systemIdOrCodeRelMapping.containsKey(systemIdOrCode)) {
            return CurrentSystemHolder.getCachingSystemId(systemIdOrCode);
        }
        String systemId = null;
        Map<String, String> map = systemIdOrCodeRelMapping;
        synchronized (map) {
            if (systemIdOrCodeRelMapping.containsKey(systemIdOrCode)) {
                return CurrentSystemHolder.getCachingSystemId(systemIdOrCode);
            }
            BizSystem system = CurrentSystemHolder.getBizSystem(systemIdOrCode);
            if (system == null) {
                // empty if block
            }
            if (system == null) {
                systemIdOrCodeRelMapping.put(systemIdOrCode, null);
            } else {
                systemId = system.getId();
                systemIdOrCodeRelMapping.put(system.getId(), system.getCode());
                systemIdOrCodeRelMapping.put(system.getCode(), system.getId());
            }
        }
        return systemId;
    }

    public static String getCachingSystemKey(String systemId) {
        if (!systemIdOrCodeRelMapping.containsKey(systemId)) {
            CurrentSystemHolder.validateSystemId(systemId);
        }
        return systemIdOrCodeRelMapping.get(systemId);
    }

    public static String getCachingSystemId(String systemIdOrCode) {
        String value = systemIdOrCodeRelMapping.get(systemIdOrCode);
        if (value != null) {
            if (StringUtils.isNumeric((CharSequence)systemIdOrCode)) {
                return systemIdOrCode;
            }
            return value;
        }
        return null;
    }

    public static BizSystem getBizSystem(String idOrCode) {
        return CurrentSystemHolder.getSystems().stream().filter(o -> idOrCode.equals(o.getId()) || idOrCode.equals(o.getCode())).findFirst().orElse(null);
    }

    public static BizSystem getSystem(String domain, String routeName) {
        if (!multiSystemMode) {
            return CurrentSystemHolder.localCacheHubRef.get().mainSystem;
        }
        if (domain != null && CurrentSystemHolder.localCacheHubRef.get().domainSystemMappings.containsKey(domain)) {
            return CurrentSystemHolder.localCacheHubRef.get().domainSystemMappings.get(domain);
        }
        for (BizSystem system : CurrentSystemHolder.localCacheHubRef.get().systems) {
            for (BizSystemModule module : system.getModules()) {
                if (module.isGlobal() || module.isGateway() || !module.getResolveRouteNames().contains(routeName)) continue;
                return system;
            }
        }
        return null;
    }

    public static BizSystemPortal getSystemPortal(String domain) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            return null;
        }
        if (CurrentSystemHolder.localCacheHubRef.get().domainSystemMappings.containsKey(domain)) {
            List<BizSystemPortal> portals = CurrentSystemHolder.localCacheHubRef.get().domainSystemMappings.get(domain).getPortals();
            for (BizSystemPortal portal : portals) {
                if (!StringUtils.equals((CharSequence)portal.getDomain(), (CharSequence)domain)) continue;
                return portal;
            }
            log.warn(">> can't match BizSystemPortal -> domain:{}", (Object)domain);
        }
        return null;
    }

    public static BizSystemModule getModule(String route) {
        BizSystemModule module = CurrentSystemHolder.localCacheHubRef.get().routeModuleRelMappings.get(route);
        if (module == null) {
            module = CurrentSystemHolder.localCacheHubRef.get().routeModuleRelMappings.get(GlobalContext.APPID);
        }
        return module;
    }

    public static BizSystemModule getModuleByServiceId(String serviceId) {
        return CurrentSystemHolder.getModules().stream().filter(m -> StringUtils.equalsIgnoreCase((CharSequence)serviceId, (CharSequence)m.getServiceId())).findFirst().orElse(null);
    }

    public static List<String> getRouteNames() {
        return CurrentSystemHolder.localCacheHubRef.get().routeNames;
    }

    public static List<BizSystemModule> getModules() {
        return CurrentSystemHolder.localCacheHubRef.get().modules;
    }

    public static KeyValuePair getOpenClientIdSecret(String systemId) {
        if (systemId == null) {
            return null;
        }
        return CurrentSystemHolder.localCacheHubRef.get().openClientMappings.get(systemId);
    }

    public static List<BizSystemModule> getAndLoadModules() {
        if (localCacheHubRef.get() == null) {
            LocalCacheHub newLocalCacheHub = new LocalCacheHub();
            CurrentSystemHolder.load(newLocalCacheHub);
            localCacheHubRef.set(newLocalCacheHub);
        }
        return CurrentSystemHolder.localCacheHubRef.get().modules;
    }

    public static void reload() {
        log.info(">> SystemMetadata reload BEGIN...");
        LocalCacheHub localCacheHub = new LocalCacheHub();
        CurrentSystemHolder.load(localCacheHub);
        LocalCacheHub originCache = localCacheHubRef.get();
        localCacheHubRef.set(localCacheHub);
        if (originCache != null) {
            originCache.destory();
        }
        CurrentSystemHolder.initModuleApiInfos(false);
        log.info(">> SystemMetadata reload END!!!");
    }

    private static synchronized void load(LocalCacheHub localCacheHub) {
        if (localCacheHub.mainSystem != null) {
            return;
        }
        String proValue = ResourceUtils.getProperty((String)"mendmix-cloud.proxy.multi-system.ignoreSubRoutes");
        if (StringUtils.isNotBlank((CharSequence)proValue)) {
            String[] parts = StringUtils.split((String)proValue, (String)";");
            for (String part : parts) {
                if (StringUtils.isBlank((CharSequence)part)) continue;
                String[] subParts = StringUtils.split((String)part, (String)":");
                localCacheHub.ignoreSubRouteMappings.put(subParts[0], Arrays.asList(StringUtils.split((String)subParts[1], (String)",")));
            }
        }
        CurrentSystemHolder.loadAllModules(localCacheHub);
        for (BizSystemModule module : localCacheHub.modules) {
            String proxyUri = ResourceUtils.getProperty((String)(module.getServiceId() + ".route.proxyUri"));
            if (StringUtils.isNotBlank((CharSequence)proxyUri)) {
                module.setProxyUri(proxyUri);
                log.info(" \u8986\u76d6\u670d\u52a1[{}]\u8def\u7531:{}", (Object)module.getServiceId(), (Object)proxyUri);
            }
            module.format();
            if (module.isSubGateway() || module.isGateway()) continue;
            module.setSubGateway(module.getStripPrefix() == 0);
        }
        StringBuilder logBuilder = new StringBuilder("> \n============load systems begin================");
        logBuilder.append("\nmainSystem:\n -").append(localCacheHub.mainSystem.toString());
        if (multiSystemMode) {
            logBuilder.append("\nmountSystem:");
            for (BizSystem system : localCacheHub.systems) {
                if (StringUtils.equals((CharSequence)system.getId(), (CharSequence)localCacheHub.mainSystem.getId())) continue;
                logBuilder.append("\n -").append(system.toString());
            }
        }
        logBuilder.append("\n============load systems end================\n");
        log.info(logBuilder.toString());
    }

    public static void initModuleApiInfos(boolean forceUpdate) {
        log.info(">>initModuleApiInfos BEGIN...");
        List<BizSystem> systems = CurrentSystemHolder.getSystems();
        int mouleNums = 0;
        for (BizSystem system : systems) {
            mouleNums += system.getModules().size();
        }
        int poolSize = mouleNums < 10 ? mouleNums : 10;
        ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
        final CountDownLatch counter = new CountDownLatch(mouleNums);
        final ArrayList errorModules = new ArrayList();
        try {
            for (BizSystem system : systems) {
                for (final BizSystemModule module : system.getModules()) {
                    executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            boolean result = ModuleApiRefreshTask.initModuleApiInfos(module);
                            if (!result) {
                                errorModules.add(module);
                                log.info(">> \u6a21\u5757[{},{}] \u521d\u59cb\u5316apis\u5931\u8d25\uff0c\u52a0\u5165\u91cd\u8bd5\u961f\u5217", (Object)module.getServiceId(), (Object)module.getMetadataUri());
                            }
                            counter.countDown();
                        }
                    });
                }
            }
            counter.await();
            executorService.shutdown();
            log.info(">>initModuleApiInfos END!!!");
        }
        catch (Exception e) {
            executorService.shutdown();
        }
        if (errorModules.size() > 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 12; ++i) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Iterator iterator = errorModules.iterator();
                        while (iterator.hasNext()) {
                            BizSystemModule module = (BizSystemModule)iterator.next();
                            if (!ModuleApiRefreshTask.initModuleApiInfos(module)) continue;
                            iterator.remove();
                            log.info(">> \u6a21\u5757[{},{}] \u91cd\u8bd5\u521d\u59cb\u5316apis\u5b8c\u6210\uff01\uff01\uff01", (Object)module.getServiceId(), (Object)module.getMetadataUri());
                        }
                    }
                }
            }).start();
        }
    }

    private static void loadAllModules(LocalCacheHub localCacheHub) {
        log.info(" loadRemoteSystems BEGIN...");
        SystemInfoApi apiInstance = (SystemInfoApi)InstanceFactory.getInstance(SystemInfoApi.class);
        if (apiInstance != null) {
            log.info("> load mainSystem [{}] BEGIN...", (Object)GlobalContext.SYSTEM_KEY);
            localCacheHub.mainSystem = apiInstance.getSystemMetadata(GlobalContext.SYSTEM_KEY);
            Validate.notNull((Object)localCacheHub.mainSystem, (String)("\u7cfb\u7edf\u3010" + GlobalContext.SYSTEM_KEY + "\u3011\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
            log.info("> load mainSystem [{}] END.", (Object)GlobalContext.SYSTEM_KEY);
        } else {
            localCacheHub.mainSystem = new BizSystem();
            localCacheHub.mainSystem.setId(ResourceUtils.getProperty((String)"default.allocation.system.id", (String)"0"));
            log.warn("\n<waring>!!!!\n<waring>!!!!\n system [{}] not found!!!!!!", (Object)GlobalContext.SYSTEM_KEY);
        }
        CurrentSystemHolder.loadLocalRouteModules(localCacheHub);
        if (apiInstance != null && globalRouteEnabled) {
            List baseRouteNames = ResourceUtils.getList((String)"mendmix-cloud.base-route.names");
            List<BizSystemModule> globalModules = apiInstance.getGlobalModules();
            log.info("> globalModules size:{}", (Object)globalModules.size());
            for (BizSystemModule bizSystemModule : globalModules) {
                boolean existRoute = localCacheHub.mainSystem.getModules().stream().anyMatch(o -> o.getResolveRouteNames() != null && o.getResolveRouteNames().contains(bizSystemModule.getFirstRouteName()));
                if (existRoute) {
                    log.info("> \u5ffd\u7565\u5e94\u7528\u5df2\u5b9a\u4e49\u91cd\u590d\u7684 globalModules {}:{}", (Object)bizSystemModule.getServiceId(), (Object)bizSystemModule.getFirstRouteName());
                    continue;
                }
                if (!baseRouteNames.isEmpty() && !baseRouteNames.contains(bizSystemModule.getFirstRouteName())) {
                    log.info("> ignore globalModules {}:{}", (Object)bizSystemModule.getServiceId(), (Object)bizSystemModule.getFirstRouteName());
                    continue;
                }
                bizSystemModule.setGlobal(true);
                bizSystemModule.setSystemId(localCacheHub.mainSystem.getId());
                localCacheHub.mainSystem.getModules().add(bizSystemModule);
            }
        }
        localCacheHub.systems.add(localCacheHub.mainSystem);
        CurrentSystemHolder.buildMappingCacheData(localCacheHub, localCacheHub.mainSystem, true);
        if (apiInstance != null && multiSystemMode) {
            List<SubSystem> subSystems = null;
            if (ResourceUtils.containsProperty((String)"mendmix-cloud.proxy.multi-system.ids")) {
                List systemCodes = ResourceUtils.getList((String)"mendmix-cloud.proxy.multi-system.ids");
                subSystems = new ArrayList<SubSystem>(systemCodes.size());
                for (String systemCode : systemCodes) {
                    SubSystem subSystem = new SubSystem();
                    subSystem.setCode(systemCode);
                    subSystem.setRouteMode(ResourceUtils.getBoolean((String)"mendmix-cloud.proxy.multi-system.routeMode", (boolean)true));
                    subSystems.add(subSystem);
                }
            } else {
                try {
                    subSystems = apiInstance.getSubSystems(localCacheHub.mainSystem.getId());
                }
                catch (Exception e) {
                    log.warn("\n<waring>!!!!\n<waring>!!!!\n \u62c9\u53d6[{}]\u5b50\u7cfb\u7edf\u9519\u8bef:{}", (Object)localCacheHub.mainSystem, (Object)ExceptionFormatUtils.buildExceptionMessages((Throwable)e, (int)3));
                    subSystems = new ArrayList<SubSystem>(0);
                }
            }
            for (SubSystem subSystem : subSystems) {
                BizSystem system = apiInstance.getSystemMetadata(subSystem.getCode());
                localCacheHub.systems.add(system);
                if (StringUtils.isBlank((CharSequence)subSystem.getProxyUrl())) {
                    subSystem.setProxyUrl(system.getApiBaseUrl());
                }
                if (subSystem.isRouteMode()) {
                    CurrentSystemHolder.buildMappingCacheData(localCacheHub, system, false);
                    continue;
                }
                log.info(" \u5f00\u59cb\u6ce8\u518c\u5b50\u7cfb\u7edf[{}]\u8def\u7531....", (Object)subSystem.getCode());
                BizSystemModule subSystemModule = new BizSystemModule();
                if (StringUtils.isBlank((CharSequence)subSystem.getProxyUrl())) {
                    log.warn(" \u5b50\u7cfb\u7edf[{}]\u6ce8\u518c\u8def\u7531\u5931\u8d25,\u539f\u56e0\uff1aproxyUrl\u4e3a\u7a7a!!!!!!!", (Object)subSystem.getCode());
                    continue;
                }
                subSystemModule.setProxyUri(WebUtils.getBaseUrl((String)subSystem.getProxyUrl()));
                String url = subSystem.getProxyUrl() + "/app-management/module/compositeInfo";
                log.info(" \u67e5\u8be2\u5b50\u7cfb\u7edf\u8def\u7531\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
                CompositeModule compositeModule = null;
                try {
                    compositeModule = (CompositeModule)HttpRequestEntity.get((String)url).internalCall().execute().toObject(CompositeModule.class);
                }
                catch (Exception e) {
                    log.warn("\n<waring>!!!!\n<waring>!!!!\n \u5b50\u7cfb\u7edf[{}]\u6ce8\u518c\u8def\u7531\u5931\u8d25,\u539f\u56e0\uff1a{}", (Object)subSystem.getCode(), (Object)e.getMessage());
                    continue;
                }
                subSystemModule.setSystemId(system.getId());
                subSystemModule.setServiceId(subSystem.getCode() + "-gateway");
                subSystemModule.setResolveRouteNames(compositeModule.getRoutes());
                subSystemModule.setSubGateway(true);
                subSystemModule.setStripPrefix(0);
                CurrentSystemHolder.removeIgnoreRoute(localCacheHub, system, subSystemModule);
                if (subSystemModule.getFirstRouteName() != null) {
                    CurrentSystemHolder.buildRouteModuleMapping(localCacheHub, subSystemModule);
                }
                log.info(" \u5b8c\u6210\u6ce8\u518c\u5b50\u7cfb\u7edf[{}]\u8def\u7531\uff01\uff01\uff01", (Object)subSystem.getCode());
            }
        }
        log.info(" loadRemoteSystems END.");
    }

    private static void buildMappingCacheData(LocalCacheHub localCacheHub, BizSystem system, boolean isMainSystem) {
        BizSystemModule gatewayModule = null;
        Iterator<BizSystemModule> iterator = system.getModules().iterator();
        while (iterator.hasNext()) {
            BizSystemModule module = iterator.next();
            if (!isMainSystem) {
                String routeName = module.getFirstRouteName();
                CurrentSystemHolder.removeIgnoreRoute(localCacheHub, system, module);
                if (module.getFirstRouteName() == null) {
                    log.info(">>>ignoreSubRoute:{} for module:{}", (Object)routeName, (Object)module.getServiceId());
                    continue;
                }
            }
            if (!(remoteRouteEnabled || module.isLocal() || module.isGlobal() || module.isGateway())) {
                iterator.remove();
                log.info("> ignore remote module[{}-{}]!!!!!", (Object)module.getFirstRouteName(), (Object)module.getServiceId());
                continue;
            }
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{module.getFirstRouteName(), module.getProxyUri()})) {
                log.info("> ignore error module {}!!!!!", (Object)module);
                continue;
            }
            if (isMainSystem && GlobalContext.APPID.equalsIgnoreCase(module.getServiceId())) {
                gatewayModule = module;
                continue;
            }
            CurrentSystemHolder.buildRouteModuleMapping(localCacheHub, module);
        }
        for (BizSystemPortal portal : system.getPortals()) {
            if (!StringUtils.isNotBlank((CharSequence)portal.getDomain())) continue;
            localCacheHub.domainSystemMappings.put(portal.getDomain(), system);
            log.info("> add domainSystemMappings: {} = {}", (Object)portal.getDomain(), (Object)system.getId());
        }
        if (isMainSystem) {
            if (gatewayModule == null) {
                gatewayModule = new BizSystemModule();
                gatewayModule.setServiceId(GlobalContext.APPID);
                system.getModules().add(gatewayModule);
            }
            gatewayModule.setRouteName(GlobalContext.APPID);
            gatewayModule.setStripPrefix(0);
            if (StringUtils.isBlank((CharSequence)gatewayModule.getAnonymousUris())) {
                gatewayModule.setAnonymousUris(ResourceUtils.getProperty((String)"mendmix-cloud.acl.global.anonymousUris"));
            }
            gatewayModule.setRouteName(GlobalContext.APPID);
            CurrentSystemHolder.buildRouteModuleMapping(localCacheHub, gatewayModule);
        }
    }

    private static void buildRouteModuleMapping(LocalCacheHub localCacheHub, BizSystemModule module) {
        List<String> routeNames = module.getResolveRouteNames();
        for (String sub : routeNames) {
            if (localCacheHub.routeNames.contains(sub)) {
                log.warn("\n<waring>!!!!\n<waring>!!!!\n \u8def\u7531[{}]\u5df2\u5b58\u5728\uff01\uff01\uff01\u6a21\u5757[id:{},serviceId:{}]\u91cd\u590d\u5b9a\u4e49\uff01\uff01", new Object[]{sub, module.getId(), module.getServiceId()});
                return;
            }
            localCacheHub.routeModuleRelMappings.put(sub, module);
            localCacheHub.routeNames.add(sub);
        }
        localCacheHub.modules.add(module);
    }

    private static void loadLocalRouteModules(LocalCacheHub localCacheHub) {
        log.info(" loadLocalRouteModules BEGIN...");
        Properties properties = ResourceUtils.getAllProperties((String)"spring.cloud.gateway.routes");
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        boolean withPathPrefix = StringUtils.isNotBlank((CharSequence)GatewayConfigs.PATH_PREFIX);
        block2: for (Map.Entry<Object, Object> entry : entrySet) {
            try {
                FilterDefinition filterDefinition;
                String stripPrefix;
                if (!entry.getKey().toString().endsWith(".id")) continue;
                String prefix = entry.getKey().toString().replace(".id", "");
                BizSystemModule module = new BizSystemModule();
                module.setId(properties.getProperty(prefix + ".moduleId"));
                module.setSystemId(properties.getProperty(prefix + ".systemId"));
                module.setServiceId(entry.getValue().toString());
                module.setProxyUri(properties.getProperty(prefix + ".uri"));
                PredicateDefinition pathPredicate = new PredicateDefinition(properties.getProperty(prefix + ".predicates[0]"));
                Collection paths = pathPredicate.getArgs().values();
                ArrayList<String> routeList = new ArrayList<String>(paths.size());
                for (String path : paths) {
                    if (withPathPrefix && !path.startsWith(GatewayConfigs.PATH_PREFIX)) {
                        log.warn(" route_format_error ->routeId:{},pathPredicateValue:{}\n -route path must startWith:{}", new Object[]{entry.getKey(), path, GatewayConfigs.PATH_PREFIX});
                        continue block2;
                    }
                    String routeName = path.substring(GatewayConfigs.PATH_PREFIX.length() + 1);
                    routeName = routeName.substring(0, routeName.lastIndexOf("/"));
                    routeList.add(routeName);
                }
                if (!routeList.isEmpty()) {
                    module.setResolveRouteNames(routeList);
                }
                if (!StringUtils.isNumeric((CharSequence)(stripPrefix = (String)(filterDefinition = new FilterDefinition(properties.getProperty(prefix + ".filters[0]"))).getArgs().get("_genkey_0")))) {
                    stripPrefix = "2";
                }
                module.setStripPrefix(Integer.parseInt(stripPrefix));
                module.setMetadata(CurrentSystemHolder.parseRouteMetadata(prefix, properties));
                module.setAnonymousUris(properties.getProperty(prefix + ".anonymousUris"));
                module.setIgnoreApiPerm(Boolean.parseBoolean(properties.getProperty(prefix + ".ignoreApiPerm")));
                module.setSubGateway(module.getStripPrefix() == 0);
                module.setLocal(true);
                localCacheHub.mainSystem.getModules().add(module);
            }
            catch (Exception e) {
                log.error("loadLocalRouteModule[{}] error:{} -> ", (Object)entry.getKey().toString(), (Object)ExceptionFormatUtils.buildExceptionMessages((Throwable)e, (int)5));
            }
        }
        log.info(" loadLocalRouteModules END.");
    }

    private static Map<String, Object> parseRouteMetadata(String prefix, Properties properties) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        prefix = prefix + ".metadata.";
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = Objects.toString(entry.getKey(), null);
            if (key == null || entry.getValue() == null || !entry.getKey().toString().startsWith(prefix)) continue;
            key = key.replace(prefix, "");
            metadata.put(key, entry.getValue());
        }
        return metadata;
    }

    private static void removeIgnoreRoute(LocalCacheHub localCacheHub, BizSystem system, BizSystemModule module) {
        if (!localCacheHub.ignoreSubRouteMappings.containsKey(system.getCode())) {
            return;
        }
        List<String> ignoreRoutes = localCacheHub.ignoreSubRouteMappings.get(system.getCode());
        if (module.getResolveRouteNames().size() == 1) {
            if (ignoreRoutes.contains(module.getFirstRouteName())) {
                module.setRouteName(null);
            }
        } else {
            List<String> routeNames = module.getResolveRouteNames();
            routeNames.removeAll(ignoreRoutes);
            module.setResolveRouteNames(routeNames);
        }
    }

    static class LocalCacheHub {
        BizSystem mainSystem;
        List<BizSystem> systems = new ArrayList<BizSystem>();
        Map<String, BizSystem> domainSystemMappings = new HashMap<String, BizSystem>();
        List<BizSystemModule> modules = new ArrayList<BizSystemModule>();
        Map<String, BizSystemModule> routeModuleRelMappings = new HashMap<String, BizSystemModule>();
        Map<String, KeyValuePair> openClientMappings = new HashMap<String, KeyValuePair>();
        List<String> routeNames = new ArrayList<String>();
        Map<String, List<String>> ignoreSubRouteMappings = new HashMap<String, List<String>>();

        LocalCacheHub() {
        }

        public void destory() {
            this.mainSystem = null;
            this.systems.clear();
            this.systems = null;
            this.domainSystemMappings.clear();
            this.domainSystemMappings = null;
            this.modules.clear();
            this.modules = null;
            this.routeModuleRelMappings.clear();
            this.routeModuleRelMappings = null;
            this.openClientMappings.clear();
            this.openClientMappings = null;
            this.routeNames.clear();
            this.ignoreSubRouteMappings.clear();
            this.ignoreSubRouteMappings = null;
        }
    }
}

