/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.autoconfigure;

import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.filter.CachingRequestBodyFilter;
import org.dromara.mendmix.gateway.filter.GlobalFilter;
import org.dromara.mendmix.gateway.filter.GrayRouteFilter;
import org.dromara.mendmix.gateway.security.AuthorizationProvider;
import org.dromara.mendmix.gateway.security.DefaultAuthorizationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;

@Configuration
public class FilterRegConfig {
    @Bean
    @Order(value=-2147483648)
    @ConditionalOnProperty(name={"mendmix-cloud.request.cors.enabled"}, havingValue="true")
    public CorsWebFilter corsWebFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.addAllowedOriginPattern("*");
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        source.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsWebFilter((CorsConfigurationSource)source);
    }

    @Bean
    @Order(value=-2147483647)
    public CachingRequestBodyFilter cachingRequestBodyFilter() {
        return new CachingRequestBodyFilter();
    }

    @Bean
    @Order(value=-2147483646)
    public GlobalFilter globalFilter(@Autowired(required=false) AuthorizationProvider authorizationProvider) {
        if (authorizationProvider == null) {
            authorizationProvider = new DefaultAuthorizationProvider();
        }
        return new GlobalFilter(GatewayConfigs.PATH_PREFIX, authorizationProvider);
    }

    @Bean
    public GrayRouteFilter grayRouteFilter() {
        return new GrayRouteFilter();
    }
}

