/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.endpoint;

import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.annotation.ApiMetadata;
import org.dromara.mendmix.common.constants.PermissionLevel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exporter"})
public class ExporterController
extends org.dromara.mendmix.springweb.exporter.ExporterController
implements InitializingBean {
    private long directMemoryLimit = 0L;
    private long directMemorySafeThreshold = 0L;

    @ApiMetadata(permissionLevel=PermissionLevel.Anonymous, actionLog=false)
    @GetMapping(value={"/directMemoryStat"})
    public Map<String, String> directMemoryStat() throws IllegalArgumentException, IllegalAccessException {
        Field counterField = ReflectionUtils.findField(PlatformDependent.class, (String)"DIRECT_MEMORY_COUNTER");
        counterField.setAccessible(true);
        AtomicLong usedMemory = (AtomicLong)counterField.get(PlatformDependent.class);
        LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>(3);
        DataSize dataSize = DataSize.ofBytes((long)this.directMemoryLimit);
        stats.put("nodeName", GlobalContext.getNodeName());
        stats.put("limitMemory", dataSize.toMegabytes() + "MB");
        dataSize = DataSize.ofBytes((long)usedMemory.get());
        stats.put("usedMemory", dataSize.toString());
        if (dataSize.toMegabytes() > 0L) {
            stats.put("formatUsedMemory", dataSize.toMegabytes() + "MB");
        } else if (dataSize.toKilobytes() > 0L) {
            stats.put("formatUsedMemory", dataSize.toKilobytes() + "KB");
        }
        return stats;
    }

    public void afterPropertiesSet() throws Exception {
        Field limitField = ReflectionUtils.findField(PlatformDependent.class, (String)"DIRECT_MEMORY_LIMIT");
        limitField.setAccessible(true);
        this.directMemoryLimit = (Long)limitField.get(PlatformDependent.class);
        this.directMemorySafeThreshold = this.directMemoryLimit / 10L;
        long defaultThreshold = 0x800000L;
        if (this.directMemorySafeThreshold > defaultThreshold) {
            this.directMemorySafeThreshold = defaultThreshold;
        }
    }
}

