/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.endpoint;

import java.util.HashMap;
import java.util.Map;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.annotation.ApiMetadata;
import org.dromara.mendmix.common.constants.PermissionLevel;
import org.dromara.mendmix.common.model.WrapperResponse;
import org.dromara.mendmix.gateway.endpoint.management.HandleParam;
import org.dromara.mendmix.gateway.endpoint.management.MgtHandler;
import org.dromara.mendmix.gateway.endpoint.management.ModuleMgtHandler;
import org.dromara.mendmix.gateway.endpoint.management.RouteMgtHandler;
import org.dromara.mendmix.gateway.endpoint.management.ScheduleMgtHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/serviceExporter"})
public class ServiceExporterController {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    private static Map<String, MgtHandler> handlers = new HashMap<String, MgtHandler>();

    @RequestMapping(value={"/{handleName}/{act}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiMetadata(permissionLevel=PermissionLevel.LoginRequired)
    public WrapperResponse<?> process(ServerHttpRequest request, @PathVariable(value="handleName") String handleName, @PathVariable(value="act") String act) {
        WrapperResponse respData = null;
        try {
            HandleParam handleParam = new HandleParam(request);
            if (!handlers.containsKey(handleName)) {
                throw new MendmixBaseException("NOT SUPPORT");
            }
            Object result = handlers.get(handleName).handleRequest(act, handleParam);
            respData = new WrapperResponse(result);
        }
        catch (Exception e) {
            logger.error(handleName + "_error", (Throwable)e);
            respData = WrapperResponse.fail((Exception)e);
        }
        return respData;
    }

    static {
        handlers.put("module", new ModuleMgtHandler());
        handlers.put("route", new RouteMgtHandler());
        handlers.put("schedule", new ScheduleMgtHandler());
    }
}

