/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.endpoint.management;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;

public class HandleParam {
    private HttpMethod httpMethod;
    private String postData;
    private MultiValueMap<String, String> queryParams;

    public HandleParam(ServerHttpRequest request) {
        this.httpMethod = request.getMethod();
        this.queryParams = request.getQueryParams();
        if (this.httpMethod == HttpMethod.POST) {
            try {
                DataBuffer dataBuffer = (DataBuffer)request.getBody().blockFirst();
                InputStream inputStream = dataBuffer.asInputStream();
                this.postData = new String(IOUtils.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8.name());
                DataBufferUtils.release((DataBuffer)dataBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getPostData() {
        return this.postData;
    }

    public boolean isPostMethod() {
        return this.httpMethod == HttpMethod.POST;
    }

    public String getParameter(String name) {
        return (String)this.queryParams.getFirst((Object)name);
    }
}

