/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.endpoint.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.SafeStringUtils;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.endpoint.management.HandleParam;
import org.dromara.mendmix.gateway.endpoint.management.MgtHandler;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.spring.InstanceFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class ModuleMgtHandler
implements MgtHandler {
    @Override
    public String category() {
        return "module";
    }

    @Override
    public Object handleRequest(String actName, HandleParam handleParam) {
        String serviceId = handleParam.getParameter("serviceId");
        List<BizSystemModule> modules = CurrentSystemHolder.getModules();
        if ("list".equals(actName)) {
            if (StringUtils.isBlank((CharSequence)serviceId)) {
                List filterList = modules.stream().filter(o -> !o.isGlobal() && !o.isGateway()).collect(Collectors.toList());
                if (!Boolean.parseBoolean(handleParam.getParameter("details"))) {
                    filterList = BeanUtils.copy(filterList, BizSystemModule.class);
                    for (BizSystemModule module : filterList) {
                        module.setApiInfos(null);
                    }
                }
                return filterList;
            }
            return modules.stream().filter(o -> serviceId.equalsIgnoreCase(o.getServiceId()) || serviceId.equals(o.getRouteName())).findFirst().orElse(null);
        }
        if ("instances".equals(actName)) {
            HashMap<String, List> map = new HashMap<String, List>(modules.size());
            for (BizSystemModule module : modules) {
                if (serviceId != null && !StringUtils.equalsIgnoreCase((CharSequence)serviceId, (CharSequence)module.getServiceId())) continue;
                List instances = ((DiscoveryClient)InstanceFactory.getInstance(DiscoveryClient.class)).getInstances(module.getServiceId());
                map.put(module.getServiceId(), instances);
            }
            return map;
        }
        if ("configs".equals(actName)) {
            if (StringUtils.isBlank((CharSequence)serviceId)) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                Properties properties = ResourceUtils.getAllProperties();
                ArrayList<String> sortKeys = new ArrayList<String>();
                Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    String key = entry.getKey().toString();
                    sortKeys.add(key);
                }
                Collections.sort(sortKeys);
                for (String key : sortKeys) {
                    String value = SafeStringUtils.hideSensitiveKeyValue((String)key, (String)properties.getProperty(key));
                    result.put(key, value);
                }
                return result;
            }
            BizSystemModule module = modules.stream().filter(o -> serviceId.equalsIgnoreCase(o.getServiceId()) || serviceId.equals(o.getRouteName())).findFirst().orElse(null);
            if (module == null || module.getServiceBaseUrl() == null) {
                throw new MendmixBaseException("\u6a21\u5757\u4e0d\u5b58\u5728\u6216baseUrl\u672a\u914d\u7f6e");
            }
            String url = module.getServiceBaseUrl() + "/exporter/runtime_configs";
            return HttpRequestEntity.get((String)url).backendInternalCall().execute().toMap();
        }
        return null;
    }
}

