/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.endpoint.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.endpoint.management.HandleParam;
import org.dromara.mendmix.gateway.endpoint.management.MgtHandler;
import org.dromara.mendmix.gateway.model.BizSystemModule;

public class ScheduleMgtHandler
implements MgtHandler {
    private static List<String> ignoreServiceIds = new ArrayList<String>();

    @Override
    public String category() {
        return "schedule";
    }

    @Override
    public Object handleRequest(String actName, HandleParam handleParam) {
        if ("jobs".equals(actName)) {
            List<BizSystemModule> modules = CurrentSystemHolder.getModules();
            ArrayList<Map> list = new ArrayList<Map>();
            ArrayList<String> loadModuleKeys = new ArrayList<String>();
            for (BizSystemModule module : modules) {
                List<Map> perJobs;
                if (module.isGlobal() || module.isGateway() || loadModuleKeys.contains(module.getProxyUri()) || ignoreServiceIds.contains(module.getServiceId()) || (perJobs = this.fetchModuleJobs(module)) == null || perJobs.isEmpty()) continue;
                list.addAll(perJobs);
                loadModuleKeys.add(module.getProxyUri());
            }
            return list;
        }
        if (handleParam.isPostMethod()) {
            // empty if block
        }
        return null;
    }

    private List<Map> fetchModuleJobs(BizSystemModule module) {
        ArrayList jobs;
        String url = module.getServiceBaseUrl() + "/exporter/scheduler/list";
        try {
            jobs = HttpRequestEntity.get((String)url).backendInternalCall().execute().toList(Map.class, "jobs");
        }
        catch (MendmixBaseException e) {
            if (e.getCode() == 404 || e.getCode() == 401 || e.getCode() == 403) {
                ignoreServiceIds.add(module.getServiceId());
            }
            jobs = new ArrayList(0);
        }
        return jobs;
    }
}

