/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.exception;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.model.WrapperResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ReactiveGlobalExceptionHandler {
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public WrapperResponse<?> exceptionHandler(ServerHttpRequest request, ServerHttpResponse response, Exception e) {
        WrapperResponse resp = new WrapperResponse();
        Throwable throwable = this.getActualThrowable(e);
        if (throwable instanceof Exception) {
            e = (Exception)throwable;
        } else {
            e.printStackTrace();
            e = new MendmixBaseException(500, e.getMessage());
        }
        if (e instanceof MendmixBaseException) {
            MendmixBaseException e1 = (MendmixBaseException)e;
            resp.setCode(e1.getCode());
            resp.setMsg(e1.getMessage());
        } else if (e instanceof MethodArgumentNotValidException) {
            resp.setCode(400);
            List errors = ((MethodArgumentNotValidException)e).getBindingResult().getAllErrors();
            StringBuilder fieldNames = new StringBuilder();
            for (ObjectError error : errors) {
                String fieldName = this.parseFieldName(error);
                fieldNames.append(fieldName).append(",");
            }
            resp.setBizCode("error.parameter.notValid");
            resp.setMsg("\u53c2\u6570\u9519\u8bef[" + fieldNames.toString() + "]");
        } else {
            Throwable parent = e.getCause();
            if (parent instanceof IllegalStateException) {
                resp.setCode(501);
                resp.setMsg(e.getMessage());
            } else {
                resp.setCode(500);
                resp.setMsg("\u7cfb\u7edf\u7e41\u5fd9");
            }
        }
        return resp;
    }

    private Throwable getActualThrowable(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private String parseFieldName(ObjectError error) {
        String[] codes = error.getCodes();
        if (codes.length >= 2) {
            return StringUtils.split((String)codes[1], (String)".")[1];
        }
        if (codes.length >= 1) {
            return StringUtils.split((String)codes[0], (String)".")[2];
        }
        return error.getCode();
    }
}

