/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.exception;

import io.netty.channel.ConnectTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.LogMessageFormat;
import org.dromara.mendmix.gateway.filter.pre.FallbackBreakerHandler;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.server.ServerRequest;

public class RouteErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    @Autowired(required=false)
    private FallbackBreakerHandler fallbackHandler;

    public RouteErrorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties.Resources resources, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resources, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        HashMap<String, Object> errorAttributes;
        Throwable error = ExceptionUtils.getRootCause((Throwable)super.getError(request));
        String exceptionDetails = ExceptionFormatUtils.buildExceptionMessages((Throwable)error, (int)5);
        if (request.exchange().getAttributes().containsKey("_debug_trace_context")) {
            logger.error("routeError" + LogMessageFormat.buildLogTail(), error);
        } else {
            logger.warn("routeError{},url:{},errorMsg:{}", new Object[]{LogMessageFormat.buildLogTail(), request.path(), exceptionDetails});
        }
        String msg = StringUtils.defaultString((String)error.getMessage(), (String)"\u7cfb\u7edf\u7e41\u5fd9");
        Integer code = HttpStatus.INTERNAL_SERVER_ERROR.value();
        if (error.getClass().getName().contains("UnknownHostException") || msg.contains("Connection refused") || msg.contains("Failed to resolve '") || msg.contains("connection timed out") || error instanceof UnknownHostException || error instanceof ConnectTimeoutException) {
            msg = "Service Unavailable";
            code = 503;
        }
        Map<String, Object> fallbackData = null;
        if (code == 503 && this.fallbackHandler != null) {
            fallbackData = (Map)this.fallbackHandler.handle(request.exchange(), false);
        }
        if (fallbackData != null) {
            errorAttributes = fallbackData;
        } else {
            errorAttributes = new HashMap<String, Object>(3);
            errorAttributes.put("msg", msg);
            errorAttributes.put("code", code);
            HashMap<String, String> data = new HashMap<String, String>(3);
            BizSystemModule module = RequestContextHelper.getCurrentModule(request.exchange());
            data.put("serviceId", module.getServiceId());
            data.put("path", request.path());
            data.put("exception", exceptionDetails);
            errorAttributes.put("extraMsg", data);
        }
        RequestContextHelper.clearCustomContextAttributes(request.exchange());
        return errorAttributes;
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        if (errorAttributes != null && errorAttributes.containsKey("code")) {
            return (Integer)errorAttributes.get("code");
        }
        return HttpStatus.INTERNAL_SERVER_ERROR.value();
    }
}

