/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.async.AsyncInitializer;
import org.dromara.mendmix.common.model.WrapperResponse;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.filter.FakeResponseHandler;
import org.dromara.mendmix.gateway.filter.PostFilterHandler;
import org.dromara.mendmix.gateway.filter.PreFilterHandler;
import org.dromara.mendmix.gateway.filter.post.ResponseRewriteHandler;
import org.dromara.mendmix.gateway.filter.post.RewriteBodyServerHttpResponse;
import org.dromara.mendmix.gateway.filter.pre.GlobalHeaderHanlder;
import org.dromara.mendmix.gateway.filter.pre.OpenApiSignatureHandler;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.spring.InstanceFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstracRouteFilter
implements GlobalFilter,
Ordered,
CommandLineRunner,
AsyncInitializer {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    private List<String> ignoreUris = Arrays.asList("/actuator/health");
    private List<PreFilterHandler> preHandlers = new ArrayList<PreFilterHandler>();
    private List<PostFilterHandler> postHandlers = new ArrayList<PostFilterHandler>();
    @Autowired(required=false)
    private List<FakeResponseHandler> fakeResponseHandlers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (exchange.getAttribute("ctx-ignore-filter") != null) {
            return chain.filter(exchange);
        }
        String requestUri = exchange.getRequest().getPath().value();
        if (this.ignoreUris.stream().anyMatch(o -> requestUri.endsWith((String)o))) {
            return chain.filter(exchange);
        }
        exchange.getAttributes().put("ctx-start-time", System.currentTimeMillis());
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        try {
            Object fakeResp = null;
            if (this.fakeResponseHandlers != null) {
                Mono<Void> handler;
                Mono mono = this.fakeResponseHandlers.iterator();
                while (mono.hasNext() && (fakeResp = (handler = mono.next()).handle(exchange, true)) == null) {
                }
                if (fakeResp != null) {
                    if (fakeResp instanceof Map) {
                        if (((Map)fakeResp).containsKey("__NULL_BODY_")) {
                            fakeResp = null;
                        } else if ("feign".equals(exchange.getRequest().getHeaders().getFirst("User-Agent"))) {
                            fakeResp = ((Map)fakeResp).get("data");
                        }
                    }
                    if (fakeResp == null) {
                        mono = Mono.empty();
                        return mono;
                    }
                    byte[] fallbackRespBytes = JsonUtils.toJsonBytes((Object)fakeResp);
                    handler = RequestContextHelper.writeData(exchange, fallbackRespBytes, 200);
                    return handler;
                }
            }
            ServerHttpRequest.Builder requestBuilder = exchange.getRequest().mutate();
            for (PreFilterHandler handler : this.preHandlers) {
                requestBuilder = handler.process(exchange, module, requestBuilder);
            }
            exchange = exchange.mutate().request(requestBuilder.build()).build();
            boolean rewritePath = StringUtils.isNotBlank((CharSequence)module.getRewriteUriPrefix());
            String rewriteBaseUrl = null;
            if (rewritePath) {
                RequestContextHelper.rewriteRouteUri(exchange, module, rewriteBaseUrl);
                RequestContextHelper.setContextAttr(exchange, "ctx-cross-cloud-request", true);
            }
            if (logger.isTraceEnabled() || exchange.getAttributes().containsKey("_debug_trace_context")) {
                logger.info("<trace_logging> final_forward_request \n - uri:{}\n - headers:{}", (Object)Objects.toString(exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR)), (Object)exchange.getRequest().getHeaders());
            }
            ServerWebExchange.Builder newExchangeBuilder = exchange.mutate().request(requestBuilder.build());
            boolean rewriteBody = true;
            if (rewriteBody) {
                RewriteBodyServerHttpResponse newResponse = new RewriteBodyServerHttpResponse(exchange, module);
                exchange = newExchangeBuilder.response((ServerHttpResponse)newResponse).build();
                Mono mono = chain.filter(exchange.mutate().response((ServerHttpResponse)newResponse).build());
                return mono;
            }
            exchange = newExchangeBuilder.build();
            Mono mono = chain.filter(exchange);
            return mono;
        }
        catch (Exception e) {
            if (!(e instanceof MendmixBaseException)) {
                logger.error("MENDMIX-TRACE-LOGGGING-->> requestFilter_error", (Throwable)e);
            }
            ServerHttpResponse response = exchange.getResponse();
            byte[] bytes = JsonUtils.toJson((Object)WrapperResponse.fail((Exception)e)).getBytes(StandardCharsets.UTF_8);
            if ("feign".equalsIgnoreCase(exchange.getRequest().getHeaders().getFirst("User-Agent"))) {
                response.setRawStatusCode(Integer.valueOf(500));
            }
            response.getHeaders().add("Content-Type", "application/json; charset=utf-8");
            Mono mono = response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(bytes)));
            return mono;
        }
        finally {
            ThreadLocalContext.unset();
        }
    }

    public int getOrder() {
        return 10001;
    }

    public void run(String ... args) throws Exception {
        Map customPostHandlers;
        Map customPreHandlers;
        this.preHandlers.add(new GlobalHeaderHanlder());
        if (GatewayConfigs.openApiEnabled) {
            this.preHandlers.add(new OpenApiSignatureHandler());
        }
        if (!(customPreHandlers = InstanceFactory.getBeansOfType(PreFilterHandler.class)).isEmpty()) {
            this.preHandlers.addAll(customPreHandlers.values());
        }
        if (this.preHandlers.size() > 1) {
            this.preHandlers = this.preHandlers.stream().sorted(Comparator.comparing(PreFilterHandler::order)).collect(Collectors.toList());
        }
        if (GatewayConfigs.respRewriteEnabled) {
            this.postHandlers.add(new ResponseRewriteHandler());
        }
        if (!(customPostHandlers = InstanceFactory.getBeansOfType(PostFilterHandler.class)).isEmpty()) {
            this.postHandlers.addAll(customPostHandlers.values());
        }
        RewriteBodyServerHttpResponse.setHandlers(this.postHandlers);
    }

    public void doInitialize() {
        for (PreFilterHandler preFilterHandler : this.preHandlers) {
            preFilterHandler.onStarted();
        }
        for (PostFilterHandler postFilterHandler : this.postHandlers) {
            postFilterHandler.onStarted();
        }
    }

    public static void addIgnoreResponseFilterUri(ServerWebExchange exchange) {
    }
}

