/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter;

import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CachingRequestBodyFilter
implements WebFilter {
    private static final String HTTP = "http";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (request.getMethod() == HttpMethod.GET || RequestContextHelper.isMultipartContent(request)) {
            return chain.filter(exchange);
        }
        String scheme = request.getURI().getScheme();
        if (!scheme.startsWith(HTTP)) {
            return chain.filter(exchange);
        }
        ServerHttpRequest cachedRequest = (ServerHttpRequest)exchange.getAttributeOrDefault("cachedServerHttpRequestDecorator", null);
        if (cachedRequest != null) {
            exchange.getAttributes().remove("cachedServerHttpRequestDecorator");
            return chain.filter(exchange.mutate().request(cachedRequest).build());
        }
        DataBuffer body = (DataBuffer)exchange.getAttributeOrDefault("cachedRequestBody", null);
        if (body != null) {
            return chain.filter(exchange);
        }
        RequestContextHelper.clearContextAttributes(exchange);
        RequestContextHelper.setContextAttr(exchange, "ctx-clearContextAttributes", true);
        return ServerWebExchangeUtils.cacheRequestBody((ServerWebExchange)exchange, serverHttpRequest -> {
            if (serverHttpRequest == exchange.getRequest()) {
                return chain.filter(exchange);
            }
            return chain.filter(exchange.mutate().request(serverHttpRequest).build());
        });
    }
}

