/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter;

import java.util.List;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.exception.ForbiddenAccessException;
import org.dromara.mendmix.common.exception.UnauthorizedException;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.model.WrapperResponse;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystem;
import org.dromara.mendmix.gateway.model.BizSystemPortal;
import org.dromara.mendmix.gateway.security.AuthorizationProvider;
import org.dromara.mendmix.gateway.security.SpecUnauthorizedHandler;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class GlobalFilter
implements WebFilter {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.security");
    private String matchUriPrefix;
    private AuthorizationProvider authorizationProvider;
    private SpecUnauthorizedHandler specUnauthorizedHandler = new SpecUnauthorizedHandler();

    public GlobalFilter(String matchUriPrefix, AuthorizationProvider authorizationProvider) {
        this.matchUriPrefix = matchUriPrefix;
        this.authorizationProvider = authorizationProvider;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        try {
            String uri = RequestContextHelper.getOriginRequestUri(exchange);
            if (this.matchUriPrefix != null && !uri.startsWith(this.matchUriPrefix) || RequestContextHelper.isWebSocketRequest(exchange.getRequest())) {
                exchange.getAttributes().put("ctx-ignore-filter", Boolean.TRUE);
                return chain.filter(exchange);
            }
            if (request.getMethod().equals((Object)HttpMethod.OPTIONS)) {
                return chain.filter(exchange);
            }
            RequestContextHelper.clearContextAttributes(exchange);
            this.beforeAuthentication(exchange);
            ServerHttpResponse response = exchange.getResponse();
            AuthUser currentUser = null;
            try {
                currentUser = this.authorizationProvider.doAuthorization(request);
            }
            catch (UnauthorizedException e) {
                if (!this.specUnauthorizedHandler.customAuthentication(exchange)) {
                    RequestContextHelper.clearContextAttributes(exchange);
                    return this.writeErrorResponse(request, response, (MendmixBaseException)((Object)e));
                }
                if (request.getHeaders().containsKey((Object)"x-auth-user")) {
                    AuthUser authUser = AuthUser.decode((String)request.getHeaders().getFirst("x-auth-user"));
                    CurrentRuntimeContext.setAuthUser((AuthUser)authUser);
                }
            }
            catch (ForbiddenAccessException e) {
                RequestContextHelper.clearContextAttributes(exchange);
                return this.writeErrorResponse(request, response, (MendmixBaseException)((Object)e));
            }
            this.afterAuthentication(exchange, currentUser);
            return chain.filter(exchange).doFinally(s -> RequestContextHelper.clearContextAttributes(exchange));
        }
        catch (Exception e) {
            logger.error("MENDMIX-TRACE-LOGGGING-->> _global_filter_error", (Throwable)e);
            ThreadLocalContext.unset();
            exchange.getAttributes().clear();
            byte[] bytes = JsonUtils.toJsonBytes((Object)WrapperResponse.fail((Exception)e));
            return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(bytes)));
        }
    }

    private void beforeAuthentication(ServerWebExchange exchange) {
        BizSystem system;
        String systemId;
        ServerHttpRequest request = exchange.getRequest();
        String domain = RequestContextHelper.getOriginDomain(request);
        BizSystemPortal portal = CurrentSystemHolder.getSystemPortal(domain);
        if (portal != null) {
            CurrentRuntimeContext.setTenantId((String)portal.getTenantId());
            CurrentRuntimeContext.setClientType((String)portal.getClientType());
        }
        if ((systemId = this.getHeaderSystemId(request)) == null && (system = CurrentSystemHolder.getSystem()) != null) {
            systemId = system.getId();
        }
        if (systemId != null) {
            CurrentRuntimeContext.setSystemId((String)systemId);
        }
    }

    private String getHeaderSystemId(ServerHttpRequest request) {
        String systemId = request.getHeaders().getFirst("x-system-id");
        if (systemId != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("header[x-system-id]={}", (Object)systemId);
            }
            boolean matched = false;
            List<BizSystem> systems = CurrentSystemHolder.getSystems();
            for (BizSystem system : systems) {
                if (!systemId.equals(system.getId()) && !systemId.equals(system.getCode())) continue;
                systemId = system.getId();
                matched = true;
                break;
            }
            if (!matched) {
                logger.warn("MENDMIX-TRACE-LOGGGING-->> header[x-system-id]={} can't matched", (Object)systemId);
                systemId = null;
            }
        }
        return systemId;
    }

    private void afterAuthentication(ServerWebExchange exchange, AuthUser currentUser) {
    }

    private Mono<Void> writeErrorResponse(ServerHttpRequest request, ServerHttpResponse response, MendmixBaseException e) {
        if ("feign".equalsIgnoreCase(request.getHeaders().getFirst("User-Agent"))) {
            response.setRawStatusCode(Integer.valueOf(e.getCode()));
        }
        response.getHeaders().add("Content-Type", "application/json; charset=utf-8");
        byte[] bytes = JsonUtils.toJsonBytes((Object)WrapperResponse.fail((Exception)((Object)e)));
        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(bytes)));
    }
}

