/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter;

import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.http.HostMappingHolder;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.gateway.filter.GrayRouteMatcher;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GrayRouteFilter
implements GlobalFilter,
Ordered {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private Map<String, String> grayRouteMappings = ResourceUtils.getMappingValues((String)"mendmix-cloud.servicegovern.grayRoute.mapping");
    @Autowired(required=false)
    private GrayRouteMatcher grayRouteMatcher;

    public int getOrder() {
        return 10001;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (this.grayRouteMatcher == null && this.grayRouteMappings.isEmpty()) {
            return chain.filter(exchange);
        }
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        String systemId = CurrentRuntimeContext.getSystemId();
        String tenantId = CurrentRuntimeContext.getTenantId();
        AuthUser authUser = CurrentRuntimeContext.getCurrentUser();
        String grayRouteUrl = null;
        boolean usingGrayRoute = exchange.getRequest().getHeaders().containsKey((Object)"x-gray-strategy");
        if (!usingGrayRoute && this.grayRouteMatcher != null) {
            grayRouteUrl = this.grayRouteMatcher.match(exchange, systemId, module, tenantId, authUser);
            boolean bl = usingGrayRoute = grayRouteUrl != null;
        }
        if (!usingGrayRoute) {
            return chain.filter(exchange);
        }
        boolean defaultRouteMatched = false;
        if (grayRouteUrl == null || (defaultRouteMatched = "http://default-gray-route".equals(grayRouteUrl))) {
            grayRouteUrl = this.grayRouteMappings.get(module.getServiceId());
            if (grayRouteUrl == null) {
                grayRouteUrl = this.grayRouteMappings.get(module.getCurrentRouteName(exchange));
            }
            if (defaultRouteMatched && grayRouteUrl == null) {
                logger.debug(">>grayRoute for:{} NOT FOUND!!!", (Object)exchange.getRequest().getPath().value());
            }
        }
        if (StringUtils.isBlank((CharSequence)grayRouteUrl)) {
            return chain.filter(exchange);
        }
        if (!grayRouteUrl.contains(".")) {
            grayRouteUrl = HostMappingHolder.resolveUrl((String)grayRouteUrl);
        }
        URI grayRouteUri = RequestContextHelper.rewriteRouteUri(exchange, module, grayRouteUrl);
        if (logger.isTraceEnabled() || exchange.getAttributes().containsKey("_debug_trace_context")) {
            logger.info(">> GrayRouteRequest grayRouteUri:{}", (Object)grayRouteUri);
        }
        exchange.getAttributes().put("ctx-grayRouted", true);
        return chain.filter(exchange);
    }
}

