/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter.post;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.model.WrapperResponse;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.filter.PostFilterHandler;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;

public class ResponseRewriteHandler
implements PostFilterHandler {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    private static final String DEFAULT_ERROR_MSG = "\u7cfb\u7edf\u7e41\u5fd9";
    private static final String _MSG_NAME = "msg";
    private static final String _CODE_NAME = "code";
    private static final String _DATA_NAME = "data";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(ServerWebExchange exchange, BizSystemModule module, String respBodyAsString) {
        boolean rebuild;
        Object originObject;
        String responseMsg;
        String responseData;
        int statusCode;
        block33: {
            if (!exchange.getResponse().getStatusCode().is2xxSuccessful()) {
                return respBodyAsString;
            }
            if (GatewayConfigs.ignoreRewriteRoutes.contains(module.getRouteName())) {
                return respBodyAsString;
            }
            if (exchange.getRequest().getHeaders().containsKey((Object)"x-resp-keep")) {
                return respBodyAsString;
            }
            if (exchange.getResponse().getHeaders().containsKey((Object)"x-resp-keep")) {
                return respBodyAsString;
            }
            if (StringUtils.isBlank((CharSequence)respBodyAsString)) {
                return JsonUtils.toJson((Object)WrapperResponse.success());
            }
            statusCode = exchange.getResponse().getStatusCode().value();
            responseData = respBodyAsString;
            responseMsg = null;
            originObject = null;
            rebuild = false;
            try {
                boolean isCodeResp;
                boolean isJsonObject;
                if (logger.isTraceEnabled()) {
                    logger.trace("ORIGIN_RESPONSE -> {}", (Object)responseData);
                }
                if (isJsonObject = JsonUtils.isJsonObjectString((String)responseData)) {
                    originObject = JsonUtils.toHashMap((String)responseData);
                } else if (JsonUtils.isJsonArrayString((String)responseData)) {
                    originObject = JsonUtils.toList((String)responseData, Map.class);
                }
                boolean bl = isCodeResp = isJsonObject && originObject.containsKey(_CODE_NAME) && (((Map)originObject).size() == 1 || ((Map)originObject).containsKey(_DATA_NAME) || ((Map)originObject).containsKey(_MSG_NAME));
                if (!isCodeResp) {
                    rebuild = true;
                    if (statusCode != 200) {
                        try {
                            responseMsg = HttpStatus.valueOf((int)statusCode).getReasonPhrase();
                        }
                        catch (Exception e) {
                            responseMsg = DEFAULT_ERROR_MSG;
                        }
                    }
                }
                if (statusCode != 500) break block33;
            }
            catch (Exception e) {
                block34: {
                    try {
                        String error = "Error during filtering[ResponseFilter]";
                        logger.error(error, (Throwable)e);
                        statusCode = 500;
                        responseMsg = DEFAULT_ERROR_MSG;
                        if (statusCode != 500) break block34;
                    }
                    catch (Throwable throwable) {
                        if (statusCode == 500) {
                            exchange.getResponse().setStatusCode(HttpStatus.OK);
                        }
                        if (rebuild) {
                            LinkedHashMap<String, Object> rebuildObject = new LinkedHashMap<String, Object>(3);
                            rebuildObject.put(_CODE_NAME, statusCode == 200 ? 200 : 500);
                            if (StringUtils.isNotBlank((CharSequence)responseMsg)) {
                                rebuildObject.put(_MSG_NAME, responseMsg);
                            }
                            if (originObject != null) {
                                rebuildObject.put(_DATA_NAME, originObject);
                            } else if (StringUtils.isNotBlank((CharSequence)responseData)) {
                                rebuildObject.put(_DATA_NAME, originObject);
                            }
                            responseData = JsonUtils.toJson(rebuildObject);
                        }
                        throw throwable;
                    }
                    exchange.getResponse().setStatusCode(HttpStatus.OK);
                }
                if (rebuild) {
                    LinkedHashMap<String, Object> rebuildObject = new LinkedHashMap<String, Object>(3);
                    rebuildObject.put(_CODE_NAME, statusCode == 200 ? 200 : 500);
                    if (StringUtils.isNotBlank((CharSequence)responseMsg)) {
                        rebuildObject.put(_MSG_NAME, responseMsg);
                    }
                    if (originObject != null) {
                        rebuildObject.put(_DATA_NAME, originObject);
                    } else if (StringUtils.isNotBlank((CharSequence)responseData)) {
                        rebuildObject.put(_DATA_NAME, originObject);
                    }
                    responseData = JsonUtils.toJson(rebuildObject);
                }
            }
            exchange.getResponse().setStatusCode(HttpStatus.OK);
        }
        if (rebuild) {
            LinkedHashMap<String, Object> rebuildObject = new LinkedHashMap<String, Object>(3);
            rebuildObject.put(_CODE_NAME, statusCode == 200 ? 200 : 500);
            if (StringUtils.isNotBlank((CharSequence)responseMsg)) {
                rebuildObject.put(_MSG_NAME, responseMsg);
            }
            if (originObject != null) {
                rebuildObject.put(_DATA_NAME, originObject);
            } else if (StringUtils.isNotBlank((CharSequence)responseData)) {
                rebuildObject.put(_DATA_NAME, originObject);
            }
            responseData = JsonUtils.toJson(rebuildObject);
        }
        return responseData;
    }

    @Override
    public int order() {
        return 1;
    }
}

