/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter.post;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.dromara.mendmix.gateway.filter.AbstracRouteFilter;
import org.dromara.mendmix.gateway.filter.PostFilterHandler;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.spring.InstanceFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RewriteBodyServerHttpResponse
extends ServerHttpResponseDecorator {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    private final String APPLICATION_JSON_STRING = MediaType.APPLICATION_JSON.toString();
    private static final String GZIP_ENCODE = "gzip";
    private static final int BODY_SIZE_LIMIT = 262144;
    private static final int LOGGING_BODY_SIZE_LIMIT = 102400;
    private static List<HttpMessageReader<?>> messageReaders;
    private static List<PostFilterHandler> handlers;
    private ServerWebExchange exchange;
    private BizSystemModule module;
    private String bodyString;

    public RewriteBodyServerHttpResponse(ServerWebExchange exchange, BizSystemModule module) {
        super(exchange.getResponse());
        this.exchange = exchange;
        this.module = module;
    }

    public static void setHandlers(List<PostFilterHandler> handlers) {
        if (handlers.size() > 1) {
            handlers = handlers.stream().sorted(Comparator.comparing(PostFilterHandler::order)).collect(Collectors.toList());
        }
        RewriteBodyServerHttpResponse.handlers = handlers;
    }

    private static List<HttpMessageReader<?>> getMessageReaders() {
        if (messageReaders == null) {
            messageReaders = ((ServerCodecConfigurer)InstanceFactory.getInstance(ServerCodecConfigurer.class)).getReaders();
        }
        return messageReaders;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        String originalResponseContentType;
        boolean isNullBody;
        HttpHeaders headers = this.exchange.getResponse().getHeaders();
        if (headers.containsKey((Object)"Content-Disposition")) {
            AbstracRouteFilter.addIgnoreResponseFilterUri(this.exchange);
            return super.writeWith(body);
        }
        long contentLength = headers.getContentLength();
        boolean withTransferEncodingHeader = headers.containsKey((Object)"Transfer-Encoding");
        boolean bl = isNullBody = !withTransferEncodingHeader && contentLength == 0L;
        if (isNullBody) {
            for (PostFilterHandler handler : handlers) {
                this.bodyString = handler.process(this.exchange, this.module, this.bodyString);
            }
            if (this.bodyString != null) {
                byte[] bytes2 = this.bodyString.getBytes();
                DataBuffer dataBuffer = this.exchange.getResponse().bufferFactory().wrap(bytes2);
                headers.setContentLength((long)bytes2.length);
                return super.writeWith((Publisher)Flux.just((Object)dataBuffer));
            }
            return super.writeWith(body);
        }
        boolean isGzip = GZIP_ENCODE.equalsIgnoreCase(headers.getFirst("Content-Encoding"));
        if (logger.isTraceEnabled()) {
            logger.trace("handleReadResponseBody begin -> isGzip:{}", (Object)isGzip);
        }
        if ((originalResponseContentType = (String)this.exchange.getAttribute("original_response_content_type")) != null && originalResponseContentType.startsWith(this.APPLICATION_JSON_STRING)) {
            ClientResponse clientResponse = ClientResponse.create((HttpStatus)this.getDelegate().getStatusCode(), RewriteBodyServerHttpResponse.getMessageReaders()).body(Flux.from(body)).build();
            Mono bodyMono = clientResponse.bodyToMono(byte[].class).map(bytes -> {
                if (isGzip) {
                    bytes = RewriteBodyServerHttpResponse.gzipDecode(bytes);
                }
                if (((byte[])bytes).length >= 102400) {
                    this.exchange.getAttributes().put("ctx-resp-content-length", ((byte[])bytes).length);
                }
                this.bodyString = new String((byte[])bytes, StandardCharsets.UTF_8);
                for (PostFilterHandler handler : handlers) {
                    this.bodyString = handler.process(this.exchange, this.module, this.bodyString);
                }
                bytes = this.bodyString.getBytes();
                if (isGzip) {
                    bytes = RewriteBodyServerHttpResponse.gzipEncode(this.bodyString.getBytes());
                }
                int newContentLength = ((byte[])bytes).length;
                if (contentLength <= 0L) {
                    this.exchange.getAttributes().put("ctx-resp-content-length", newContentLength);
                }
                if (headers.containsKey((Object)"x-resp-keep") && newContentLength > 262144) {
                    AbstracRouteFilter.addIgnoreResponseFilterUri(this.exchange);
                }
                return bytes;
            });
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)bodyMono, byte[].class);
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(this.exchange, this.exchange.getResponse().getHeaders());
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                Flux messageBody = outputMessage.getBody();
                if (!withTransferEncodingHeader) {
                    messageBody = messageBody.doOnNext(data -> headers.setContentLength((long)data.readableByteCount()));
                }
                return this.getDelegate().writeWith((Publisher)messageBody);
            }));
        }
        if (RequestContextHelper.getCurrentApi(this.exchange) != null) {
            AbstracRouteFilter.addIgnoreResponseFilterUri(this.exchange);
        }
        return super.writeWith(body);
    }

    private static byte[] gzipDecode(byte[] encoded) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            GZIPInputStream gis = new GZIPInputStream(bis);
            return FileCopyUtils.copyToByteArray((InputStream)gis);
        }
        catch (IOException e) {
            throw new IllegalStateException("couldn't decode body from gzip", e);
        }
    }

    private static byte[] gzipEncode(byte[] original) {
        try {
            ByteArrayOutputStream bis = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bis);
            FileCopyUtils.copy((byte[])original, (OutputStream)gos);
            return bis.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("couldn't encode body to gzip", e);
        }
    }
}

