/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter.pre;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.cache.adapter.ExpireableObject;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.constants.ValueType;
import org.dromara.mendmix.common.exception.MainErrorType;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.model.PageParams;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.GatewayConstants;
import org.dromara.mendmix.gateway.filter.BreakerCondition;
import org.dromara.mendmix.gateway.filter.FakeResponseHandler;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.helper.RequestFallbackHelper;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.gateway.model.FallbackRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.server.ServerWebExchange;

public class FallbackBreakerHandler
implements FakeResponseHandler,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.edge");
    private static final String CTX_FALLBACK_RULE_KEY = "__ctx_FallbackRule";
    private static final String FALLBACK_RULE_KEY_PRIFIX = String.format("fallbackRule:%s:", GlobalContext.SYSTEM_KEY);
    private static final String FALLBACK_RULE_ID_MAPPING_PREFIX = String.format("fallbackRuleIdMapping:%s:", GlobalContext.SYSTEM_KEY);
    private static final String URI_REL_FALLBACK_RULE_MAPPING_KEY_PRIFIX = String.format("fallbackRuleUriMapping:%s:", GlobalContext.SYSTEM_KEY);
    private static final String ANY_URI_WILDCARD = "/*";
    private List<FallbackRule> blankRules = new ArrayList<FallbackRule>(0);
    private Map<String, Map<String, List<FallbackRule>>> staticRules = new HashMap<String, Map<String, List<FallbackRule>>>();
    private Cache<String, Object> level1Cache = CacheBuilder.newBuilder().maximumSize(10000L).weakValues().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    @Autowired(required=false)
    private BreakerCondition breakerCondition;

    @Override
    public Object handle(ServerWebExchange exchange, boolean preHandle) {
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        if (module.isGateway()) {
            return null;
        }
        boolean traceLogging = logger.isTraceEnabled() || exchange.getAttributes().containsKey("_debug_trace_context");
        ApiInfo apiInfo = RequestContextHelper.getCurrentApi(exchange);
        if (this.breakerCondition != null && !this.breakerCondition.match(exchange, module, apiInfo)) {
            if (traceLogging) {
                logger.info("<trace_loggging> breakerCondition matched uri:{}", (Object)RequestContextHelper.getOriginRequestUri(exchange));
            }
            return null;
        }
        try {
            List<FallbackRule> matchedRules = this.matchFallbackRules(exchange, module.getServiceId(), apiInfo);
            if (matchedRules == null || matchedRules.isEmpty()) {
                return null;
            }
            Optional<FallbackRule> optional = matchedRules.stream().filter(rule -> {
                if (rule.getStrategy() == null) {
                    return false;
                }
                if (preHandle && !rule.isBreakerMode()) {
                    return false;
                }
                return rule.currentMatch(exchange);
            }).findFirst();
            if (!optional.isPresent()) {
                return null;
            }
            FallbackRule rule2 = optional.get();
            if (traceLogging) {
                logger.info("<trace_loggging> request[{}] fallback -> usingRule:{}", (Object)RequestContextHelper.getOriginRequestUri(exchange), (Object)JsonUtils.toJson((Object)rule2));
            }
            String requestURI = RequestContextHelper.getOriginRequestUri(exchange);
            if (GatewayConstants.FallbackStrategy.hitCache.name().equals(rule2.getStrategy())) {
                String cacheData;
                String hitKey = rule2.getFallbackSourceKey();
                if (hitKey == null) {
                    hitKey = RequestContextHelper.getCurrentRequestHitKey(exchange, true);
                }
                if (traceLogging) {
                    logger.info("<trace_loggging> request[{}] fallback -> hitCacheKey:{}", (Object)requestURI, (Object)hitKey);
                }
                if ((cacheData = CacheUtils.getFallbackCache((String)hitKey)) != null) {
                    Map data = JsonUtils.toHashMap((String)cacheData, Object.class);
                    return data;
                }
            } else {
                if (GatewayConstants.FallbackStrategy.forwardBackup.name().equals(rule2.getStrategy())) {
                    return RequestFallbackHelper.handleForwardUrl(exchange, rule2.getFallbackSourceKey());
                }
                if (GatewayConstants.FallbackStrategy.returnBlank.name().equals(rule2.getStrategy())) {
                    HashMap<String, Serializable> result = new HashMap<String, Serializable>(2);
                    result.put("code", Integer.valueOf(200));
                    Page data = null;
                    if (apiInfo == null) {
                        data = new HashMap(0);
                    } else if (ValueType.page == apiInfo.getReturnType()) {
                        String body = RequestContextHelper.getCachingBodyString(exchange);
                        PageParams pageParam = (PageParams)JsonUtils.toObject((String)body, PageParams.class);
                        data = Page.blankPage((int)pageParam.getPageNo(), (int)pageParam.getPageSize());
                    } else if (ValueType.array == apiInfo.getReturnType()) {
                        data = new ArrayList(0);
                    } else if (ValueType.object == apiInfo.getReturnType()) {
                        data = new HashMap(0);
                    }
                    result.put("data", (Serializable)data);
                    return result;
                }
                if (GatewayConstants.FallbackStrategy.throwException.name().equals(rule2.getStrategy())) {
                    throw new MendmixBaseException(MainErrorType.FALLBACK_REQUEST_LIMIT);
                }
                if (GatewayConstants.FallbackStrategy.returnJson.name().equals(rule2.getStrategy())) {
                    HashMap<String, Object> result = new HashMap<String, Object>(2);
                    result.put("code", 200);
                    result.put("data", JsonUtils.toHashMap((String)rule2.getFallbackContent()));
                    return result;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof MendmixBaseException) {
                throw e;
            }
            logger.warn(">>handleFallbackBreaker ERROR -> uri:{}, error:{}", (Object)exchange.getRequest().getPath().value(), (Object)ExceptionFormatUtils.buildExceptionMessages((Throwable)e, (int)3));
        }
        return null;
    }

    public List<FallbackRule> getAllFallbackRules() {
        ArrayList<FallbackRule> list = new ArrayList<FallbackRule>();
        List<BizSystemModule> modules = CurrentSystemHolder.getModules();
        for (BizSystemModule module : modules) {
            list.addAll(this.getFallbackRules(module.getServiceId(), null));
        }
        return list;
    }

    public List<FallbackRule> getFallbackRules(String serviceId, String uriKey) {
        String mappingCacheKey = FALLBACK_RULE_ID_MAPPING_PREFIX + serviceId;
        Collection ruleKeys = CacheUtils.getMapStringValues((String)mappingCacheKey).values();
        ArrayList<FallbackRule> rules = new ArrayList<FallbackRule>(ruleKeys.size());
        for (String ruleKey : ruleKeys) {
            FallbackRule rule = (FallbackRule)CacheUtils.get((String)ruleKey);
            if (rule != null) {
                if (uriKey != null && !uriKey.equals(rule.getUriKey())) continue;
                rules.add(rule);
                continue;
            }
            CacheUtils.remove((String[])new String[]{ruleKey});
        }
        return rules;
    }

    public String saveFallbackRule(FallbackRule rule) {
        FallbackRule existsRule;
        String ruleKey = FallbackBreakerHandler.buildRuleKey(rule);
        if (StringUtils.isBlank((CharSequence)rule.getId())) {
            rule.setId(DigestUtils.md5((Object)ruleKey));
        }
        if ((existsRule = (FallbackRule)CacheUtils.get((String)ruleKey)) != null && !StringUtils.equals((CharSequence)existsRule.getId(), (CharSequence)rule.getId())) {
            CacheUtils.remove((String[])new String[]{ruleKey});
        }
        CacheUtils.set((String)ruleKey, (Object)rule, (long)0L);
        String mappingCacheKey = FALLBACK_RULE_ID_MAPPING_PREFIX + rule.getServiceId();
        CacheUtils.setMapStringValue((String)mappingCacheKey, (String)rule.getId(), (String)ruleKey);
        String groupMappingKey = FallbackBreakerHandler.buildRuleGroupMappingKey(rule.getServiceId());
        ArrayList<String> existsMappings = (ArrayList<String>)CacheUtils.getMapValue((String)groupMappingKey, (String)rule.getUriKey());
        if (existsMappings == null) {
            existsMappings = new ArrayList<String>();
        }
        existsMappings.add(ruleKey);
        CacheUtils.setMapValue((String)groupMappingKey, (String)rule.getUriKey(), existsMappings);
        if (ANY_URI_WILDCARD.equals(rule.getUriKey())) {
            this.level1Cache.invalidateAll();
        } else {
            this.level1Cache.invalidate((Object)(groupMappingKey + rule.getUriKey()));
        }
        logger.info(">> saveFallbackRule finished!!! serviceId:{},rule:{}", (Object)rule.getServiceId(), (Object)JsonUtils.toJson((Object)rule));
        return rule.getId();
    }

    public boolean removeFallbackRule(FallbackRule rule) {
        String ruleKey = null;
        if (StringUtils.isNotBlank((CharSequence)rule.getId())) {
            String mappingCacheKey = FALLBACK_RULE_ID_MAPPING_PREFIX + rule.getServiceId();
            ruleKey = CacheUtils.getMapStringValue((String)mappingCacheKey, (String)rule.getId());
        }
        if (ruleKey == null) {
            ruleKey = FallbackBreakerHandler.buildRuleKey(rule);
        }
        if (!CacheUtils.exists(ruleKey)) {
            return false;
        }
        CacheUtils.remove((String[])new String[]{ruleKey});
        String groupMappingKey = FallbackBreakerHandler.buildRuleGroupMappingKey(rule.getServiceId());
        List existsMappings = (List)CacheUtils.getMapValue((String)groupMappingKey, (String)rule.getUriKey());
        if (existsMappings != null && existsMappings.contains(ruleKey)) {
            existsMappings.remove(ruleKey);
            CacheUtils.setMapValue((String)groupMappingKey, (String)rule.getUriKey(), (Object)existsMappings);
        }
        if (ANY_URI_WILDCARD.equals(rule.getUriKey())) {
            this.level1Cache.invalidateAll();
        } else {
            this.level1Cache.invalidate((Object)(groupMappingKey + rule.getUriKey()));
        }
        logger.info(">> removeFallbackRule finished!!! rule:{}", (Object)rule);
        return true;
    }

    public boolean withHitCacheFallbackRule(ServerWebExchange exchange, ApiInfo apiInfo) {
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        List<FallbackRule> rules = this.matchFallbackRules(exchange, module.getServiceId(), apiInfo);
        return rules != null && rules.stream().anyMatch(rule -> GatewayConstants.FallbackStrategy.hitCache.name().equals(rule.getStrategy()));
    }

    private List<FallbackRule> matchFallbackRules(ServerWebExchange exchange, String serviceId, ApiInfo apiInfo) {
        String uriKey;
        List<FallbackRule> rules = (List<FallbackRule>)exchange.getAttribute(CTX_FALLBACK_RULE_KEY);
        if (rules != null) {
            return rules;
        }
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        if (apiInfo != null) {
            uriKey = apiInfo.getIdentifier();
        } else {
            String method = exchange.getRequest().getMethod().name();
            String uri = RequestContextHelper.getOriginRequestUri(exchange);
            uri = uri.substring(module.getUriPrefix().length());
            uriKey = BizSystemModule.buildApiIdentifier(method, uri);
        }
        String groupMappingKey = FallbackBreakerHandler.buildRuleGroupMappingKey(serviceId);
        String localCacheKey = groupMappingKey + uriKey;
        rules = this.getRuleFromLocalCache(localCacheKey);
        if (rules != null) {
            exchange.getAttributes().put(CTX_FALLBACK_RULE_KEY, rules);
            return rules;
        }
        rules = this.getFallbackRules(serviceId, uriKey);
        if ((rules == null || rules.isEmpty()) && this.staticRules.containsKey(module.getServiceId())) {
            rules = this.staticRules.get(module.getServiceId()).get(uriKey);
        }
        if (rules == null) {
            rules = this.blankRules;
            this.level1Cache.put((Object)localCacheKey, (Object)new ExpireableObject(rules, 10L));
        } else {
            this.level1Cache.put((Object)localCacheKey, rules);
        }
        exchange.getAttributes().put(CTX_FALLBACK_RULE_KEY, rules);
        return rules;
    }

    private List<FallbackRule> getRuleFromLocalCache(String key) {
        Object o = this.level1Cache.getIfPresent((Object)key);
        if (o instanceof ExpireableObject) {
            ExpireableObject expObj = (ExpireableObject)o;
            return expObj.isExpired() ? null : (List)expObj.getTarget();
        }
        return (List)o;
    }

    public void afterPropertiesSet() throws Exception {
        List list = ResourceUtils.getConfigObjects((String)"mendmix-cloud.governance.fallback.rule", FallbackRule.class);
        for (FallbackRule rule : list) {
            List<FallbackRule> rules;
            Map<String, List<FallbackRule>> ruleMaping = this.staticRules.get(rule.getServiceId());
            if (ruleMaping == null) {
                ruleMaping = new HashMap<String, List<FallbackRule>>();
                this.staticRules.put(rule.getServiceId(), ruleMaping);
            }
            if ((rules = ruleMaping.get(rule.getUriKey())) == null) {
                rules = new ArrayList<FallbackRule>();
                ruleMaping.put(rule.getUriKey(), rules);
            }
            rules.add(rule);
        }
        logger.info(">>>>staticRules>>>>\n{}", (Object)JsonUtils.toJson(this.staticRules));
    }

    @Override
    public int order() {
        return 0;
    }

    private static String buildRuleGroupMappingKey(String serviceId) {
        return URI_REL_FALLBACK_RULE_MAPPING_KEY_PRIFIX + serviceId;
    }

    private static String buildRuleKey(FallbackRule rule) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{rule.getServiceId(), rule.getHitType(), rule.getUriKey()})) {
            throw new MendmixBaseException("\u53c2\u6570[serviceId,hitType,uriKey]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return FALLBACK_RULE_KEY_PRIFIX + rule.getServiceId() + "_" + rule.getHitType() + "_" + rule.getUriKey();
    }
}

