/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter.pre;

import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.TokenGenerator;
import org.dromara.mendmix.gateway.filter.PreFilterHandler;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.springweb.client.RequestHeaderBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class GlobalHeaderHanlder
implements PreFilterHandler {
    @Override
    public ServerHttpRequest.Builder process(ServerWebExchange exchange, BizSystemModule module, ServerHttpRequest.Builder requestBuilder) {
        AuthUser currentUser;
        String tenantId;
        Boolean trustedRequest;
        String systemId;
        String clientType;
        ServerHttpRequest.Builder reqBuilder;
        HttpHeaders headers = exchange.getRequest().getHeaders();
        ServerHttpRequest.Builder builder = reqBuilder = requestBuilder == null ? exchange.getRequest().mutate() : requestBuilder;
        if (!headers.containsKey((Object)"x-request-id")) {
            reqBuilder.header("x-request-id", new String[]{TokenGenerator.generate((String[])new String[0])});
        }
        reqBuilder.header("x-invoker-is-gateway", new String[]{Boolean.TRUE.toString()});
        if (!headers.containsKey((Object)"x-invoke-token")) {
            reqBuilder.header("x-invoke-token", new String[]{TokenGenerator.generateWithSign()});
        }
        if ((clientType = CurrentRuntimeContext.getClientType()) != null) {
            reqBuilder.header("x-client-type", new String[]{clientType});
        }
        if ((systemId = CurrentRuntimeContext.getSystemId()) != null) {
            reqBuilder.header("x-system-id", new String[]{systemId});
        }
        if (!(trustedRequest = (Boolean)ThreadLocalContext.get((String)"ctx-trusted-request", (Object)false)).booleanValue()) {
            for (String headerName : RequestHeaderBuilder.sensitiveHeaders) {
                if (!headers.containsKey((Object)headerName)) continue;
                reqBuilder.headers(httpHeaders -> httpHeaders.remove((Object)headerName));
            }
        }
        if (!(trustedRequest.booleanValue() && headers.containsKey((Object)"x-tenant-id") || (tenantId = CurrentRuntimeContext.getTenantId((boolean)false)) == null)) {
            reqBuilder.header("x-tenant-id", new String[]{tenantId});
        }
        if (!(trustedRequest.booleanValue() && headers.containsKey((Object)"x-auth-user") || (currentUser = CurrentRuntimeContext.getCurrentUser()) == null)) {
            reqBuilder.header("x-auth-user", new String[]{currentUser.toEncodeString()});
        }
        return reqBuilder;
    }

    @Override
    public int order() {
        return 8;
    }
}

