/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter.pre;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ParameterUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.filter.PreFilterHandler;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.gateway.model.OpenApiConfig;
import org.dromara.mendmix.gateway.security.OpenApiConfigProvider;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class OpenApiSignatureHandler
implements PreFilterHandler {
    static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    private static Map<String, OpenApiConfig> openApiConfigs = new ConcurrentHashMap<String, OpenApiConfig>();
    private OpenApiConfigProvider configProvider = (OpenApiConfigProvider)InstanceFactory.getInstance(OpenApiConfigProvider.class);

    public OpenApiSignatureHandler() {
        Properties properties = ResourceUtils.getAllProperties((String)"mendmix-cloud.openapi.client-config.mapping");
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String clientId = k.toString().split("\\[|\\]")[1];
            OpenApiConfig config = new OpenApiConfig(clientId, v.toString());
            if (GatewayConfigs.openApiScopeEnabled) {
                List apis = ResourceUtils.getList((String)("mendmix-cloud.openapi.apiscope.mapping[" + clientId + "]"));
                config.setGrantedApis(apis);
            }
            openApiConfigs.put(clientId, config);
        }));
    }

    public OpenApiConfig getOpenApiConfig(String clientId) {
        OpenApiConfig openApiConfig = openApiConfigs.get(clientId);
        if (openApiConfig == null && this.configProvider != null && (openApiConfig = this.configProvider.openApiConfig(clientId)) != null) {
            openApiConfigs.put(clientId, openApiConfig);
        }
        if (openApiConfig == null) {
            throw new MendmixBaseException("clientId[" + clientId + "]\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        return openApiConfig;
    }

    @Override
    public ServerHttpRequest.Builder process(ServerWebExchange exchange, BizSystemModule module, ServerHttpRequest.Builder requestBuilder) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        String sign = headers.getFirst("x-open-sign");
        if (StringUtils.isBlank((CharSequence)sign)) {
            return requestBuilder;
        }
        String uri = exchange.getRequest().getPath().value();
        ApiInfo apiInfo = module.getApiInfo(exchange.getRequest().getMethodValue(), uri);
        if (apiInfo == null || !apiInfo.isOpenApi()) {
            throw new MendmixBaseException(500, "\u8be5\u63a5\u53e3\u672a\u5f00\u653e\u8bbf\u95ee\u6743\u9650");
        }
        String timestamp = this.validateTimeStamp(headers);
        String clientId = headers.getFirst("x-open-clientId");
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new MendmixBaseException(400, "\u8bf7\u6c42\u5934[x-open-clientId]\u7f3a\u5931");
        }
        String requestId = exchange.getRequest().getHeaders().getFirst("x-request-id");
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new MendmixBaseException("\u8bf7\u6c42\u5934[x-request-id]\u7f3a\u5931");
        }
        OpenApiConfig openApiConfig = this.getOpenApiConfig(clientId);
        String body = RequestContextHelper.getCachingBodyString(exchange);
        HashMap map = JsonUtils.toHashMap((String)body.toString(), Object.class);
        if (map == null) {
            map = new HashMap();
        }
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        for (Map.Entry entry : queryParams.entrySet()) {
            if (entry.getValue() == null) continue;
            if (((List)entry.getValue()).size() == 1) {
                map.put(entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            if (((List)entry.getValue()).size() <= 1) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        String signBaseString = StringUtils.trimToEmpty((String)ParameterUtils.mapToQueryParams(map)) + timestamp + requestId + openApiConfig.getClientSecret();
        String expectSign = DigestUtils.md5((Object)signBaseString);
        if (!expectSign.equals(sign)) {
            throw new MendmixBaseException(400, "\u7b7e\u540d\u9519\u8bef");
        }
        if (GatewayConfigs.openApiScopeEnabled) {
            String removeContextPathUri = uri.substring(GatewayConfigs.PATH_PREFIX.length());
            if (openApiConfig.getGrantedApis() == null || !openApiConfig.getGrantedApis().contains(removeContextPathUri)) {
                logger.info("MENDMIX-TRACE-LOGGGING-->> openapi_error_apiUnauthorized -> clientId:{},uri:{}", (Object)openApiConfig.getClientId(), (Object)apiInfo.getUri());
                throw new MendmixBaseException(403, "\u672a\u5f00\u901a\u8be5\u63a5\u53e3\u8bbf\u95ee\u6743\u9650");
            }
        }
        ThreadLocalContext.set((String)"ctx-trusted-request", (Object)Boolean.TRUE);
        return requestBuilder;
    }

    private String validateTimeStamp(HttpHeaders headers) {
        String timestamp = headers.getFirst("timestamp");
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            throw new MendmixBaseException("\u8bf7\u6c42\u5934[timestamp]\u7f3a\u5931");
        }
        long diff = Math.abs(System.currentTimeMillis() - Long.parseLong(timestamp));
        if (diff > GatewayConfigs.REQUEST_TIME_OFFSET_THRESHOLD) {
            throw new MendmixBaseException("timestamp\u8303\u56f4\u5931\u6548");
        }
        return timestamp;
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public void onStarted() {
        if (this.configProvider == null) {
            return;
        }
        logger.info("MENDMIX-TRACE-LOGGGING-->> init OpenApiConfigs begin...");
        List<OpenApiConfig> configs = this.configProvider.allOpenApiConfigs();
        if (configs != null) {
            for (OpenApiConfig config : configs) {
                openApiConfigs.put(config.getClientId(), config);
            }
        }
        logger.info("MENDMIX-TRACE-LOGGGING-->> init OpenApiConfigs finish -> clientIds:{}", openApiConfigs.keySet());
    }
}

