/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.filter.pre;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.exception.MainErrorType;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.task.SubTimerTask;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.filter.FakeResponseHandler;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.gateway.model.BizSystem;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.gateway.model.RatelimitStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.server.ServerWebExchange;

public class RatelimitHandler
implements FakeResponseHandler,
CommandLineRunner,
SubTimerTask {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private static final String ANY_URI_WILDCARD = "/*";
    private String fetchUrl = "http://paas-systemmgt-svc/ratelimitRule/findBySystemIds";
    private Cache<String, RateLimiter> rateLimiterHub = CacheBuilder.newBuilder().maximumSize(ResourceUtils.getLong((String)"mendmix-cloud.governance.ratelimit.maxCacheSize", (long)30000L)).expireAfterWrite((long)ResourceUtils.getInt((String)"mendmix-cloud.governance.ratelimit.maxCacheMinutes", (int)15), TimeUnit.MINUTES).build();
    private Map<String, Map<String, RatelimitStrategy>> serviceStrategies = new ConcurrentHashMap<String, Map<String, RatelimitStrategy>>();
    private Map<String, Map<Pattern, RatelimitStrategy>> wildcardServiceStrategies = new ConcurrentHashMap<String, Map<Pattern, RatelimitStrategy>>();
    @Autowired(required=false)
    private DiscoveryClient discoveryClient;
    private int activePodNums = 1;

    @Override
    public Object handle(ServerWebExchange exchange, boolean preHandle) {
        boolean getPermit;
        RateLimiter limiter = this.getRateLimiter(exchange);
        boolean bl = getPermit = limiter == null || limiter.tryAcquire();
        if (!getPermit) {
            throw new MendmixBaseException(MainErrorType.TOO_MANY_REQUEST_LIMIT);
        }
        if (RequestContextHelper.isDebugMode(exchange) && limiter != null) {
            logger.info("<TRACE-LOGGGING> uri:{} \u83b7\u5f97\u9650\u6d41\u9501...,limiterTotal:{}", (Object)RequestContextHelper.getOriginRequestUri(exchange), (Object)this.rateLimiterHub.size());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RateLimiter getRateLimiter(ServerWebExchange exchange) {
        ApiInfo apiInfo = RequestContextHelper.getCurrentApi(exchange);
        if (apiInfo == null) {
            return null;
        }
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        RatelimitStrategy strategy = this.findActiveRuleByUri(module.getServiceId(), apiInfo.getIdentifier());
        if (strategy == null) {
            return null;
        }
        String resolveHitKey = strategy.resolveHitKey(exchange, module.getServiceId(), apiInfo);
        if (resolveHitKey != null) {
            RateLimiter rateLimiter = (RateLimiter)this.rateLimiterHub.getIfPresent((Object)resolveHitKey);
            if (rateLimiter != null) {
                return rateLimiter;
            }
            Cache<String, RateLimiter> cache = this.rateLimiterHub;
            synchronized (cache) {
                rateLimiter = (RateLimiter)this.rateLimiterHub.getIfPresent((Object)resolveHitKey);
                if (rateLimiter != null) {
                    return rateLimiter;
                }
                double permitsPerSecond = strategy.getPermitsPerSecond();
                if (this.activePodNums > 1) {
                    permitsPerSecond /= (double)this.activePodNums;
                }
                rateLimiter = RateLimiter.create((double)permitsPerSecond);
                this.rateLimiterHub.put((Object)resolveHitKey, (Object)rateLimiter);
                return rateLimiter;
            }
        }
        return null;
    }

    public List<RatelimitStrategy> findRatelimitStrategies(String serviceId) {
        ArrayList<RatelimitStrategy> rules = new ArrayList<RatelimitStrategy>();
        if (this.serviceStrategies.containsKey(serviceId)) {
            rules.addAll(this.serviceStrategies.get(serviceId).values());
        }
        if (this.wildcardServiceStrategies.containsKey(serviceId)) {
            rules.addAll(this.wildcardServiceStrategies.get(serviceId).values());
        }
        return rules;
    }

    public String saveRatelimitStrategy(RatelimitStrategy strategy) {
        Pattern pattern;
        String serviceId = strategy.getServiceId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{serviceId, strategy.getHitType(), strategy.getUriKey()})) {
            return null;
        }
        BizSystemModule module = CurrentSystemHolder.getModuleByServiceId(strategy.getServiceId());
        if (module == null) {
            throw new MendmixBaseException("\u670d\u52a1\u6a21\u5757[" + serviceId + "]\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)strategy.getId())) {
            strategy.setId(DigestUtils.md5((Object)(serviceId + strategy.getHitType() + strategy.getUriKey())));
        }
        this.removeRatelimitStrategy(serviceId, strategy.getId());
        Map<String, RatelimitStrategy> uriRuleMapping = this.serviceStrategies.get(serviceId);
        if (uriRuleMapping == null) {
            uriRuleMapping = new HashMap<String, RatelimitStrategy>();
            this.serviceStrategies.put(serviceId, uriRuleMapping);
        }
        if ((pattern = strategy.getUriPattern()) == null) {
            uriRuleMapping.put(strategy.getUriKey(), strategy);
        } else {
            Map<Pattern, RatelimitStrategy> patternRuleMapping = this.wildcardServiceStrategies.get(serviceId);
            if (patternRuleMapping == null) {
                patternRuleMapping = new HashMap<Pattern, RatelimitStrategy>();
                this.wildcardServiceStrategies.put(serviceId, patternRuleMapping);
            }
            patternRuleMapping.put(pattern, strategy);
        }
        this.removeRateLimiters(serviceId);
        return strategy.getId();
    }

    public void removeRatelimitStrategy(String serviceId, String id) {
        RatelimitStrategy strategy = this.findActiveRuleById(serviceId, id);
        if (strategy != null) {
            if (strategy.getUriPattern() == null) {
                this.serviceStrategies.get(strategy.getServiceId()).remove(strategy.getUriKey());
            } else {
                this.wildcardServiceStrategies.get(strategy.getServiceId()).remove(strategy.getUriPattern());
            }
        }
        this.removeRateLimiters(serviceId);
    }

    public void removeRatelimitStrategy(RatelimitStrategy strategy) {
        if (StringUtils.isBlank((CharSequence)strategy.getId())) {
            strategy.setId(DigestUtils.md5((Object)(strategy.getServiceId() + strategy.getHitType() + strategy.getUriKey())));
        }
        this.removeRatelimitStrategy(strategy.getServiceId(), strategy.getId());
    }

    private RatelimitStrategy findActiveRuleById(String serviceId, String id) {
        RatelimitStrategy rule = null;
        if (this.serviceStrategies.containsKey(serviceId)) {
            rule = this.serviceStrategies.get(serviceId).values().stream().filter(o -> o.getId().equals(id)).findFirst().orElse(null);
        }
        if (rule == null && this.wildcardServiceStrategies.containsKey(serviceId)) {
            rule = this.wildcardServiceStrategies.get(serviceId).values().stream().filter(o -> o.getId().equals(id)).findFirst().orElse(null);
        }
        return rule;
    }

    private RatelimitStrategy findActiveRuleByUri(String serviceId, String uri) {
        RatelimitStrategy rule = null;
        if (this.serviceStrategies.containsKey(serviceId)) {
            rule = this.serviceStrategies.get(serviceId).values().stream().filter(o -> o.getUriKey().equals(uri)).findFirst().orElse(null);
        }
        if (rule == null && this.wildcardServiceStrategies.containsKey(serviceId)) {
            rule = this.wildcardServiceStrategies.get(serviceId).values().stream().filter(o -> o.getUriPattern().matcher(uri).matches()).findFirst().orElse(null);
        }
        if (rule == null && this.serviceStrategies.containsKey(serviceId)) {
            rule = this.serviceStrategies.get(serviceId).get(ANY_URI_WILDCARD);
        }
        return rule;
    }

    private void removeRateLimiters(String ... serviceIds) {
        if (serviceIds == null) {
            this.rateLimiterHub.invalidateAll();
        } else {
            Set keys = this.rateLimiterHub.asMap().keySet();
            for (String key : keys) {
                for (String serviceId : serviceIds) {
                    if (!key.startsWith(serviceId)) continue;
                    this.rateLimiterHub.invalidate((Object)key);
                }
            }
        }
    }

    @Override
    public int order() {
        return 0;
    }

    public void run(String ... args) throws Exception {
        List staticStrategies = ResourceUtils.getConfigObjects((String)"mendmix-cloud.governance.ratelimit.rule", RatelimitStrategy.class);
        int index = 1;
        for (RatelimitStrategy strategy : staticStrategies) {
            strategy.setId("static_rule_" + index);
            strategy.setUriKey(strategy.getUriKey());
            try {
                this.saveRatelimitStrategy(strategy);
            }
            catch (Exception e) {
                logger.warn(">>initRemoteRule:{},error:{}", (Object)strategy.getUriKey(), (Object)e.getMessage());
            }
            ++index;
        }
    }

    public void doSchedule() {
        int newPodNums;
        if (this.discoveryClient != null && this.activePodNums != (newPodNums = this.discoveryClient.getInstances(GlobalContext.APPID).size())) {
            this.activePodNums = newPodNums;
            this.rateLimiterHub.invalidateAll();
        }
        this.initRemoteRules();
    }

    public synchronized void initRemoteRules() {
        if (!this.serviceStrategies.isEmpty() || !this.wildcardServiceStrategies.isEmpty()) {
            return;
        }
        List systemIds = CurrentSystemHolder.getSystems().stream().map(BizSystem::getId).collect(Collectors.toList());
        List list = HttpRequestEntity.post((String)this.fetchUrl).backendInternalCall().fallbackHitCache().objectBody(systemIds).execute().toList(RatelimitStrategy.class);
        for (RatelimitStrategy rule : list) {
            try {
                this.saveRatelimitStrategy(rule);
            }
            catch (Exception e) {
                logger.warn(">>initRemoteRule:{},error:{}", (Object)rule.getUriKey(), (Object)e.getMessage());
            }
        }
        if (!list.isEmpty()) {
            logger.debug(">>init GrayRoute Rules:{}", (Object)JsonUtils.toJson((Object)list));
        }
    }

    public long interval() {
        return 60000L;
    }
}

