/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.helper;

import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.dromara.mendmix.springweb.client.SimpleRestTemplateBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class HttpRequestHelper {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    private static List<String> defalutHeaders = Arrays.asList("Content-Type", "timestamp");
    private static RestTemplate restTemplate = SimpleRestTemplateBuilder.build((int)60000, (boolean)false);

    public static Mono<Void> directRequest(ServerWebExchange exchange, String targetUrl) {
        DataBuffer dataBuffer;
        boolean traceLogging = CurrentRuntimeContext.isDebugMode();
        ServerHttpRequest request = exchange.getRequest();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)targetUrl);
        if (!request.getQueryParams().isEmpty()) {
            request.getQueryParams().forEach((k, v) -> builder.queryParam(k, (Collection)v));
        }
        URI uri = builder.build().encode().toUri();
        if (logger.isTraceEnabled() || traceLogging) {
            logger.info(">> proxyUri:{}", (Object)uri);
        }
        HttpHeaders headers = new HttpHeaders();
        request.getHeaders().forEach((k, v) -> {
            if (!v.isEmpty() && (defalutHeaders.contains(k) || k.startsWith("x-"))) {
                headers.add(k, (String)v.get(0));
            }
        });
        if (!headers.containsKey((Object)"Content-Type")) {
            headers.set("Content-Type", APPLICATION_JSON_CHARSET_UTF_8);
        }
        if (!headers.containsKey((Object)"timestamp")) {
            headers.set("timestamp", CurrentRuntimeContext.timestamp());
        }
        headers.set("x-request-id", RequestContextHelper.getRequestId(exchange));
        headers.set("Connection", "close");
        String serviceChain = RequestContextHelper.buildServiceChainHeader(headers);
        headers.set("x-forwarded-service-chain", serviceChain);
        byte[] requestData = null;
        if (exchange.getRequest().getMethod() != HttpMethod.GET && (dataBuffer = (DataBuffer)exchange.getAttribute("cachedRequestBody")) != null) {
            try {
                requestData = IOUtils.toByteArray((InputStream)dataBuffer.asInputStream());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MendmixBaseException("\u8bfb\u53d6\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
            }
        }
        if (traceLogging) {
            int contentLength = 0;
            if (requestData != null) {
                contentLength = requestData.length;
            }
            logger.info(">> proxy request \nuri:{} \n -headers:{}\n -contentLength:{}", new Object[]{uri, headers, contentLength});
        }
        HttpEntity requestEntity = new HttpEntity(requestData, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(uri, request.getMethod(), requestEntity, byte[].class);
        byte[] body = (byte[])responseEntity.getBody();
        if (traceLogging) {
            logger.info(">> proxy response statusCode:{} \n -headers:{} \n -bodySize:{}", new Object[]{responseEntity.getStatusCodeValue(), responseEntity.getHeaders(), body == null ? -1 : body.length});
        }
        ServerHttpResponse response = exchange.getResponse();
        response.setRawStatusCode(Integer.valueOf(responseEntity.getStatusCodeValue()));
        HttpHeaders responseHeaders = responseEntity.getHeaders();
        if (responseHeaders.isEmpty()) {
            response.getHeaders().add("Content-Type", APPLICATION_JSON_CHARSET_UTF_8);
        } else {
            response.getHeaders().addAll((MultiValueMap)responseHeaders);
        }
        if (body != null) {
            return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(body)));
        }
        return Mono.empty();
    }
}

