/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.helper;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.cache.CacheExpires;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.crypt.RSA;
import org.dromara.mendmix.common.util.ResourceUtils;

public class RSAKeyPairHolder {
    private static String publicKeyString;
    private static RSAPrivateKey appPrivateKey;
    private static RSAPublicKey appPublicKey;

    public static RSAPrivateKey getPrivateKey() {
        return appPrivateKey;
    }

    public static RSAPublicKey getPublicKey() {
        return appPublicKey;
    }

    public static String getPublicKeyString() {
        return publicKeyString;
    }

    static {
        String privateyKeyString = ResourceUtils.getProperty((String)"mendmix-cloud.decrypt.privateyKey");
        publicKeyString = ResourceUtils.getProperty((String)"mendmix-cloud.decrypt.publicKey");
        if (privateyKeyString == null) {
            privateyKeyString = CacheUtils.getStr((String)("privateyKey:" + GlobalContext.SYSTEM_KEY));
            publicKeyString = CacheUtils.getStr((String)("publicKey:" + GlobalContext.SYSTEM_KEY));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{privateyKeyString, publicKeyString})) {
            try {
                appPrivateKey = RSA.getPrivateKey((String)privateyKeyString);
                appPublicKey = RSA.getPublicKey((String)publicKeyString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (appPublicKey == null) {
            RSA.RSAKeyPair rsaKeyPair = RSA.generateKeyPair((int)1024);
            appPrivateKey = rsaKeyPair.getPrivateKey();
            appPublicKey = rsaKeyPair.getPublicKey();
            publicKeyString = Base64.getEncoder().encodeToString(appPublicKey.getEncoded());
            privateyKeyString = Base64.getEncoder().encodeToString(appPrivateKey.getEncoded());
            CacheUtils.setStr((String)("privateyKey:" + GlobalContext.SYSTEM_KEY), (String)privateyKeyString, (long)CacheExpires.todayEndSeconds());
            CacheUtils.setStr((String)("publicKey:" + GlobalContext.SYSTEM_KEY), (String)publicKeyString, (long)CacheExpires.todayEndSeconds());
        }
    }
}

